/*!\file InterpFromGrid.c
 * \brief: data interpolation from a list of (x,y,values) into mesh grids
 
	InterpFromGrid.c

	usage:
	data_mesh=InterpFromGrid(x,y,data,x_mesh,y_mesh);
	
	where:

		input:
		x,y: coordinates of matrix data
		data - matrix holding the data to be interpolated onto the mesh.
		x_mesh,y_mesh: coordinates of the mesh grids onto which we interpolate.
		
		output: 
		data_mesh:  vector of mesh interpolated data.

*/
	
#include "./InterpFromGrid.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]) {

	int i,j;

	/*input: */
	double* x=NULL;
	double* y=NULL;

	int     x_rows;
	int     y_rows;

	double* data=NULL; 
	int     data_rows,data_cols;

	double* x_mesh=NULL;
	double* y_mesh=NULL;
	
	int     x_mesh_rows;
	int     y_mesh_rows;

	double default_value;

	/* output: */
	Vec  data_mesh=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&InterpFromGridUsage);

	/*Input datasets: */
	FetchData((void**)&x,&x_rows,NULL,XHANDLE,"Matrix","Mat");
	FetchData((void**)&y,&y_rows,NULL,YHANDLE,"Matrix","Mat");
	FetchData((void**)&data,&data_rows,&data_cols,DATAHANDLE,"Matrix","Mat");
	FetchData((void**)&x_mesh,&x_mesh_rows,NULL,XMESHHANDLE,"Matrix","Mat");
	FetchData((void**)&y_mesh,&y_mesh_rows,NULL,YMESHHANDLE,"Matrix","Mat");
	FetchData((void**)&default_value,NULL,NULL,DEFAULTHANDLE,"Scalar",NULL);

	/* Run core computations: */
	InterpFromGridx( &data_mesh, x, x_rows,  y, y_rows, data, data_rows,data_cols, x_mesh, y_mesh, x_mesh_rows,default_value);

	/*Write data: */
	WriteData(DATAMESH,data_mesh,0,0,"Vector",NULL);

	/*end module: */
	MODULEEND();
}

void InterpFromGridUsage(void)
{
	_printf_("   usage:\n");
	_printf_("   data_mesh=InterpFromGrid(x,y,data,x_mesh,y_mesh,defult_value);\n\n");
	_printf_("   where:\n");
	_printf_("      x,y: coordinates of matrix data\n");
	_printf_("      data - matrix holding the data to be interpolated onto the mesh.\n");
	_printf_("      x_mesh,y_mesh: coordinates of the mesh grids onto which we interpolate.\n");
	_printf_("      default_value: default value if no interpolation is found.\n");
	_printf_("      data_mesh:  vector of mesh interpolated data.\n");
	_printf_("\n");
}
