function doublesToHeap(array) {
	var doubleArray = new Float64Array(array);
    var numBytes = doubleArray.length * doubleArray.BYTES_PER_ELEMENT;
	var doubleArrayPtr = Module._malloc(numBytes);
    var doubleArrayHeap = new Uint8Array(Module.HEAPU8.buffer, doubleArrayPtr, numBytes);
	doubleArrayHeap.set(new Uint8Array(doubleArray.buffer));
    return doubleArrayHeap.byteOffset;
}
function intsToHeap(array) {
	var intArray = new Int32Array(array);
    var numBytes = intArray.length * intArray.BYTES_PER_ELEMENT;
	var intArrayPtr = Module._malloc(numBytes);
    var intArrayHeap = new Uint8Array(Module.HEAPU8.buffer, intArrayPtr, numBytes);
	intArrayHeap.set(new Uint8Array(intArray.buffer));
    return intArrayHeap.byteOffset;
}
function heapToDoubles(pptr, size) {
	var ptr = Module.getValue(pptr,'i32');
	var array = Module.HEAPF64.slice(ptr / 8, ptr / 8 + size[0] * size[1]);
	return ListToMatrix(array, size[1]);
}
function heapToInts(pptr, nods) {
	var ptr = Module.getValue(pptr,'i32');
	return Module.HEAPU32.slice(ptr / 4, ptr / 4 + nods);
}
function BamgMesher(md, bamgmesh, bamggeom, bamgopts) {
/*
	   usage: var array = Triangle(domain,rifts,area);
	      where: array is made of [index,x,y,segments,segmentmarkers]
		  and index,x,y defines a triangulation, segments is an array made 
	      of exterior segments to the mesh domain outline, segmentmarkers is an array 
		  flagging each segment, domain a js array defining the domain outline  (sames for 
		  rifts) and area is the maximum area desired for any element of the resulting mesh.

		  Ok, for now, we are not dealing with rifts. Also, the domain is made of only one 
		  profile, this to avoid passing a double** pointer to js. 
*/

	//Dynamic allocations: {{{
	//Retrieve domain arrays, and allocate on Module heap: 
	//input
    var pVertices_mesh_in                   = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.Vertices));
    var pVerticesSize_mesh_in               = intsToHeap([bamgmesh.Vertices.length, bamgmesh.Vertices[0].length]);
    var pEdges_mesh_in                      = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.Edges));
    var pEdgesSize_mesh_in                  = intsToHeap([bamgmesh.Edges.length, bamgmesh.Edges[0].length]);
    var pTriangles_mesh_in                  = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.Triangle));
    var pTrianglesSize_mesh_in              = intsToHeap([bamgmesh.Triangle.length, bamgmesh.Triangle[0].length]);
    var pCrackedEdges_mesh_in               = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.CrackedEdges));
    var pCrackedEdgesSize_mesh_in           = intsToHeap([bamgmesh.CrackedEdges.length, bamgmesh.CrackedEdges[0].length]);
    var pVerticesOnGeomEdge_mesh_in         = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.VerticesOnGeomEdge));
    var pVerticesOnGeomEdgeSize_mesh_in     = intsToHeap([bamgmesh.VerticesOnGeomEdge.length, bamgmesh.VerticesOnGeomEdge[0].length]);
    var pVerticesOnGeomVertex_mesh_in       = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.VerticesOnGeomVertex));
    var pVerticesOnGeomVertexSize_mesh_in   = intsToHeap([bamgmesh.VerticesOnGeomVertex.length, bamgmesh.VerticesOnGeomVertex[0].length]);
    var pEdgesOnGeomEdge_mesh_in            = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.EdgesOnGeomEdge));
    var pEdgesOnGeomEdgeSize_mesh_in        = intsToHeap([bamgmesh.EdgesOnGeomEdge.length, bamgmesh.EdgesOnGeomEdge[0].length]);
    var pIssmSegments_mesh_in               = doublesToHeap(Array.prototype.concat.apply([], bamgmesh.IssmSegments));
    var pIssmSegmentsSize_mesh_in           = intsToHeap([bamgmesh.IssmSegments.length, bamgmesh.IssmSegments[0].length]);

    var pVertices_geom_in                   = doublesToHeap(Array.prototype.concat.apply([], bamggeom.Vertices));
    var pVerticesSize_geom_in               = intsToHeap([bamggeom.Vertices.length, bamggeom.Vertices[0].length]);
    var pEdges_geom_in                      = doublesToHeap(Array.prototype.concat.apply([], bamggeom.Edges));
    var pEdgesSize_geom_in                  = intsToHeap([bamggeom.Edges.length, bamggeom.Edges[0].length]);
    var pCorners_geom_in                    = doublesToHeap(Array.prototype.concat.apply([], bamggeom.Corners));
    var pCornersSize_geom_in                = intsToHeap([bamggeom.Corners.length, bamggeom.Corners[0].length]);
    var pRequiredVertices_geom_in           = doublesToHeap(Array.prototype.concat.apply([], bamggeom.RequiredVertices));
    var pRequiredVerticesSize_geom_in       = intsToHeap([bamggeom.RequiredVertices.length, bamggeom.RequiredVertices[0].length]);
    var pRequiredCrackedEdges_geom_in       = doublesToHeap(Array.prototype.concat.apply([], bamggeom.RequiredCrackedEdges));
    var pRequiredCrackedEdgesSize_geom_in   = intsToHeap([bamggeom.RequiredCrackedEdges.length, bamggeom.RequiredCrackedEdges[0].length]);
    var pCrackedEdges_geom_in               = doublesToHeap(Array.prototype.concat.apply([], bamggeom.CrackedEdges));
    var pCrackedEdgesSize_geom_in           = intsToHeap([bamggeom.CrackedEdges.length, bamggeom.CrackedEdges[0].length]);
    var pSubDomains_geom_in                 = doublesToHeap(Array.prototype.concat.apply([], bamggeom.SubDomains));
    var pSubDomainsSize_geom_in             = intsToHeap([bamggeom.SubDomains.length, bamggeom.SubDomains[0].length]);

    var anisomax                            = bamgopts.anisomax;
    var cutoff                              = bamgopts.coeff;
    var coeff                               = bamgopts.cutoff;
    var errg                                = bamgopts.errg;
    var gradation                           = bamgopts.gradation;
    var Hessiantype                         = bamgopts.Hessiantype;
    var maxnbv                              = bamgopts.maxnbv;
    var maxsubdiv                           = bamgopts.maxsubdiv;
    var Metrictype                          = bamgopts.Metrictype;
    var nbjacobi                            = bamgopts.nbjacobi;
    var nbsmooth                            = bamgopts.nbsmooth;
    var omega                               = bamgopts.omega;
    var power                               = bamgopts.power;
    var verbose                             = bamgopts.verbose;
    var Crack                               = bamgopts.Crack;
    var KeepVertices                        = bamgopts.KeepVertices;
    var splitcorners                        = bamgopts.splitcorners;
    var hmin                                = bamgopts.hmin;
    var hmax                                = bamgopts.hmax;
    var phminVertices                       = doublesToHeap(Array.prototype.concat.apply([], bamgopts.hminVertices));
    var phminVerticesSize                   = intsToHeap([bamgopts.hminVertices.length, bamgopts.hminVertices[0].length]);
    var phmaxVertices                       = doublesToHeap(Array.prototype.concat.apply([], bamgopts.hmaxVertices));
    var phmaxVerticesSize                   = intsToHeap([bamgopts.hmaxVertices.length, bamgopts.hmaxVertices[0].length]);
    var phVertices                          = doublesToHeap(Array.prototype.concat.apply([], bamgopts.hVertices));
    var phVerticesSize                      = intsToHeap([bamgopts.hVertices.length, bamgopts.hVertices[0].length]);
    var pmetric                             = doublesToHeap(Array.prototype.concat.apply([], bamgopts.metric));
    var pmetricSize                         = intsToHeap([bamgopts.metric.length, bamgopts.metric[0].length]);
    var pfield                              = doublesToHeap(Array.prototype.concat.apply([], bamgopts.field));
    var pfieldSize                          = intsToHeap([bamgopts.field.length, bamgopts.field[0].length]);
    var err                                 = bamgopts.err;
	
	//output
    var pVertices_geom_out                  = Module._malloc(4);
    var pVerticesSize_geom_out              = Module._malloc(4); 
    var pEdges_geom_out                     = Module._malloc(4); 
    var pEdgesSize_geom_out                 = Module._malloc(4); 
    var pCorners_geom_out                   = Module._malloc(4); 
    var pCornersSize_geom_out               = Module._malloc(4); 
    var pRequiredVertices_geom_out          = Module._malloc(4); 
    var pRequiredVerticesSize_geom_out      = Module._malloc(4); 
    var pRequiredCrackedEdges_geom_out      = Module._malloc(4); 
    var pRequiredCrackedEdgesSize_geom_out  = Module._malloc(4); 
    var pCrackedEdges_geom_out              = Module._malloc(4); 
    var pCrackedEdgesSize_geom_out          = Module._malloc(4); 
    var pSubDomains_geom_out                = Module._malloc(4); 
    var pSubDomainsSize_geom_out            = Module._malloc(4); 

    var pVertices_mesh_out                  = Module._malloc(4); 
    var pVerticesSize_mesh_out              = Module._malloc(4); 
    var pEdges_mesh_out                     = Module._malloc(4); 
    var pEdgesSize_mesh_out                 = Module._malloc(4); 
    var pTriangles_mesh_out                 = Module._malloc(4); 
    var pTrianglesSize_mesh_out             = Module._malloc(4); 
    var pCrackedEdges_mesh_out              = Module._malloc(4); 
    var pCrackedEdgesSize_mesh_out          = Module._malloc(4); 
    var pVerticesOnGeomEdge_mesh_out        = Module._malloc(4); 
    var pVerticesOnGeomEdgeSize_mesh_out    = Module._malloc(4); 
    var pVerticesOnGeomVertex_mesh_out      = Module._malloc(4); 
    var pVerticesOnGeomVertexSize_mesh_out  = Module._malloc(4); 
    var pEdgesOnGeomEdge_mesh_out           = Module._malloc(4); 
    var pEdgesOnGeomEdgeSize_mesh_out       = Module._malloc(4); 
    var pIssmSegments_mesh_out              = Module._malloc(4); 
    var pIssmSegmentsSize_mesh_out          = Module._malloc(4); 
	//}}}

	//Declare BamgMesher module: 
	BamgMesherModule = Module.cwrap('BamgMesherModule', 'number',[
        'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 
        'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 
        'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 
        'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 
        'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number', 'number']);
	
	//Call BamgMesher module: 
	BamgMesherModule(
        pVertices_mesh_out, pVerticesSize_mesh_out, pEdges_mesh_out, pEdgesSize_mesh_out, pTriangles_mesh_out, pTrianglesSize_mesh_out, pCrackedEdges_mesh_out, pCrackedEdgesSize_mesh_out, pVerticesOnGeomEdge_mesh_out, pVerticesOnGeomEdgeSize_mesh_out, pVerticesOnGeomVertex_mesh_out, pVerticesOnGeomVertexSize_mesh_out, pEdgesOnGeomEdge_mesh_out, pEdgesOnGeomEdgeSize_mesh_out, pIssmSegments_mesh_out, pIssmSegmentsSize_mesh_out, 
        pVertices_geom_out, pVerticesSize_geom_out, pEdges_geom_out, pEdgesSize_geom_out, pCorners_geom_out, pCornersSize_geom_out, pRequiredVertices_geom_out, pRequiredVerticesSize_geom_out, pRequiredCrackedEdges_geom_out, pRequiredCrackedEdgesSize_geom_out, pCrackedEdges_geom_out, pCrackedEdgesSize_geom_out, pSubDomaouts_geom_out, pSubDomaoutsSize_geom_out, 
        pVertices_mesh_in, pVerticesSize_mesh_in, pEdges_mesh_in, pEdgesSize_mesh_in, pTriangles_mesh_in, pTrianglesSize_mesh_in, pCrackedEdges_mesh_in, pCrackedEdgesSize_mesh_in, pVerticesOnGeomEdge_mesh_in, pVerticesOnGeomEdgeSize_mesh_in, pVerticesOnGeomVertex_mesh_in, pVerticesOnGeomVertexSize_mesh_in, pEdgesOnGeomEdge_mesh_in, pEdgesOnGeomEdgeSize_mesh_in, pIssmSegments_mesh_in, pIssmSegmentsSize_mesh_in, 
        pVertices_geom_in, pVerticesSize_geom_in, pEdges_geom_in, pEdgesSize_geom_in, pCorners_geom_in, pCornersSize_geom_in, pRequiredVertices_geom_in, pRequiredVerticesSize_geom_in, pRequiredCrackedEdges_geom_in, pRequiredCrackedEdgesSize_geom_in, pCrackedEdges_geom_in, pCrackedEdgesSize_geom_in, pSubDomains_geom_in, pSubDomainsSize_geom_in, 
        anisomax, cutoff, coeff, errg, gradation, Hessiantype, maxnbv, maxsubdiv, Metrictype, nbjacobi, nbsmooth, omega, power, verbose, Crack, KeepVertices, splitcorners, hmin, hmax, phminVertices, phminVerticesSize, phmaxVertices, phmaxVerticesSize, phVertices, phVerticesSize, pmetric, pmetricSize, pfield, pfieldSize, err);
	
	/*Dynamic copying from heap: {{{*/
	//recover mesh: 
    var bamgmeshout = bamgmesh();
    var bamggeomout = bamggeom();

    bamgmeshout.VerticesSize                = heapToint(pVerticesSize_mesh_out, 2);
    bamgmeshout.Vertices                    = heapToDoubles(heapToDoubles(pVertices_mesh_out), bamgmeshout.VerticesSize);
    bamgmeshout.EdgesSize                   = heapToint(pEdgesSize_mesh_out, 2);
    bamgmeshout.Edges                       = heapToDoubles(heapToDoubles(pEdges_mesh_out), bamgmeshout.EdgesSize);
    bamgmeshout.TrianglesSize               = heapToint(pTrianglesSize_mesh_out, 2);
    bamgmeshout.Triangles                   = heapToDoubles(heapToDoubles(pTriangles_mesh_out), bamgmeshout.TrianglesSize);
    bamgmeshout.CrackedEdgesSize            = heapToint(pCrackedEdgesSize_mesh_out, 2);
    bamgmeshout.CrackedEdges                = heapToDoubles(heapToDoubles(pCrackedEdges_mesh_out), bamgmeshout.CrackedEdgesSize);
    bamgmeshout.VerticesOnGeomEdgeSize      = heapToint(pVerticesOnGeomEdgeSize_mesh_out, 2);
    bamgmeshout.VerticesOnGeomEdge          = heapToDoubles(heapToDoubles(pVerticesOnGeomEdge_mesh_out), bamgmeshout.VerticesOnGeomEdgeSize);
    bamgmeshout.VerticesOnGeomVertexSize    = heapToint(pVerticesOnGeomVertexSize_mesh_out, 2);
    bamgmeshout.VerticesOnGeomVertex        = heapToDoubles(heapToDoubles(pVerticesOnGeomVertex_mesh_out), bamgmeshout.VerticesOnGeomVertexSize);
    bamgmeshout.EdgesOnGeomEdgeSize         = heapToint(pEdgesOnGeomEdgeSize_mesh_out, 2);
    bamgmeshout.EdgesOnGeomEdge             = heapToDoubles(heapToDoubles(pEdgesOnGeomEdge_mesh_out), bamgmeshout.EdgesOnGeomEdgeSize);
    bamgmeshout.IssmSegmentsSize            = heapToint(pIssmSegmentsSize_mesh_out, 2);
    bamgmeshout.IssmSegments                = heapToDoubles(heapToDoubles(pIssmSegments_mesh_out), bamgmeshout.IssmSegmentsSize);

    bamggeomout.VerticesSize                = heapToint(pVerticesSize_mesh_out, 2);
    bamggeomout.Vertices                    = heapToDoubles(heapToDoubles(pVertices_mesh_out), bamggeomout.VerticesSize);
    bamggeomout.EdgesSize                   = heapToint(pEdgesSize_mesh_out, 2);
    bamggeomout.Edges                       = heapToDoubles(heapToDoubles(pEdges_mesh_out), bamggeomout.EdgesSize);
    bamggeomout.CornersSize                 = heapToint(pCornersSize_mesh_out, 2);
    bamggeomout.Corners                     = heapToDoubles(heapToDoubles(pCorners_mesh_out), bamggeomout.CornersSize);
    bamggeomout.RequiredVerticesSize        = heapToint(pRequiredVerticesSize_mesh_out, 2);
    bamggeomout.RequiredVertices            = heapToDoubles(heapToDoubles(pRequiredVertices_mesh_out), bamggeomout.RequiredVerticesSize);
    bamggeomout.RequiredCrackedEdgesSize    = heapToint(pRequiredCrackedEdgesSize_mesh_out, 2);
    bamggeomout.RequiredCrackedEdges        = heapToDoubles(heapToDoubles(pRequiredCrackedEdges_mesh_out), bamggeomout.RequiredCrackedEdgesSize);
    bamggeomout.CrackedEdgesSize            = heapToint(pCrackedEdgesSize_mesh_out, 2);
    bamggeomout.CrackedEdges                = heapToDoubles(heapToDoubles(pCrackedEdges_mesh_out), bamggeomout.CrackedEdgesSize);
    bamggeomout.SubDomainSize               = heapToint(pSubDomainsSize_mesh_out, 2);
    bamggeomout.SubDomains                  = heapToDoubles(heapToDoubles(pSubDomains_mesh_out), bamggeomout.SubDomainsSize);
	/*}}}*/

	var return_array=[bamgmeshout, bamggeomout];

	/*Free ressources: */
    Module._free(pVertices_mesh_in);
    Module._free(pVerticesSize_mesh_in);
    Module._free(pEdges_mesh_in);
    Module._free(pEdgesSize_mesh_in);
    Module._free(pTriangles_mesh_in);
    Module._free(pTrianglesSize_mesh_in);
    Module._free(pCrackedEdges_mesh_in);
    Module._free(pCrackedEdgesSize_mesh_in);
    Module._free(pVerticesOnGeomEdge_mesh_in);
    Module._free(pVerticesOnGeomEdgeSize_mesh_in);
    Module._free(pVerticesOnGeomVertex_mesh_in);
    Module._free(pVerticesOnGeomVertexSize_mesh_in);
    Module._free(pEdgesOnGeomEdge_mesh_in);
    Module._free(pEdgesOnGeomEdgeSize_mesh_in);
    Module._free(pIssmSegments_mesh_in);
    Module._free(pIssmSegmentsSize_mesh_in);

    Module._free(pVertices_geom_in);
    Module._free(pVerticesSize_geom_in);
    Module._free(pEdges_geom_in);
    Module._free(pEdgesSize_geom_in);
    Module._free(pCorners_geom_in);
    Module._free(pCornersSize_geom_in);
    Module._free(pRequiredVertices_geom_in);
    Module._free(pRequiredVerticesSize_geom_in);
    Module._free(pRequiredCrackedEdges_geom_in);
    Module._free(pRequiredCrackedEdgesSize_geom_in);
    Module._free(pCrackedEdges_geom_in);
    Module._free(pCrackedEdgesSize_geom_in);
    Module._free(pSubDomains_geom_in);
    Module._free(pSubDomainsSize_geom_in);

    Module._free(pVertices_geom_out);
    Module._free(pVerticesSize_geom_out);
    Module._free(pEdges_geom_out);
    Module._free(pEdgesSize_geom_out);
    Module._free(pCorners_geom_out);
    Module._free(pCornersSize_geom_out);
    Module._free(pRequiredVertices_geom_out);
    Module._free(pRequiredVerticesSize_geom_out);
    Module._free(pRequiredCrackedEdges_geom_out);
    Module._free(pRequiredCrackedEdgesSize_geom_out);
    Module._free(pCrackedEdges_geom_out);
    Module._free(pCrackedEdgesSize_geom_out);
    Module._free(pSubDomains_geom_out);
    Module._free(pSubDomainsSize_geom_out);

    Module._free(pVertices_mesh_out);
    Module._free(pVerticesSize_mesh_out);
    Module._free(pEdges_mesh_out);
    Module._free(pEdgesSize_mesh_out);
    Module._free(pTriangles_mesh_out);
    Module._free(pTrianglesSize_mesh_out);
    Module._free(pCrackedEdges_mesh_out);
    Module._free(pCrackedEdgesSize_mesh_out);
    Module._free(pVerticesOnGeomEdge_mesh_out);
    Module._free(pVerticesOnGeomEdgeSize_mesh_out);
    Module._free(pVerticesOnGeomVertex_mesh_out);
    Module._free(pVerticesOnGeomVertexSize_mesh_out);
    Module._free(pEdgesOnGeomEdge_mesh_out);
    Module._free(pEdgesOnGeomEdgeSize_mesh_out);
    Module._free(pIssmSegments_mesh_out);
    Module._free(pIssmSegmentsSize_mesh_out);

    Module._free(phminVertices);
    Module._free(phminVerticesSize);
    Module._free(phmaxVertices);
    Module._free(phmaxVerticesSize);
    Module._free(phVertices);
    Module._free(phVerticesSize);
    Module._free(pmetric);
    Module._free(pmetricSize);
    Module._free(pfield);
    Module._free(pfieldSize);

	return return_array;
}
