#Test Name: SquareShelfSMBGemb
import numpy as np
from model import *
from socket import gethostname
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *
from SMBgemb import *

md = triangle(model(),'../Exp/Square.exp',200000.)
md = setmask(md,'all','')
md = parameterize(md,'../Par/SquareShelf.py')
md = setflowequation(md,'SSA','all')
md.materials.rho_ice = 910
md.cluster = generic('name',gethostname(),'np',3)

#Use of Gemb method for SMB computation
md.smb = SMBgemb()
md.smb.setdefaultparameters(md.mesh,md.geometry)

#load hourly surface forcing date from 1979 to 2009:
inputs = np.load('../Data/gemb_input.npy').item()

#setup the inputs:
md.smb.Ta = np.append(np.tile(np.conjugate(inputs['Ta0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.V = np.append(np.tile(np.conjugate(inputs['V0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.dswrf = np.append(np.tile(np.conjugate(inputs['dsw0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.dlwrf = np.append(np.tile(np.conjugate(inputs['dlw0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.P = np.append(np.tile(np.conjugate(inputs['P0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.eAir = np.append(np.tile(np.conjugate(inputs['eAir0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.pAir = np.append(np.tile(np.conjugate(inputs['pAir0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.pAir = np.append(np.tile(np.conjugate(inputs['pAir0']),(md.mesh.numberofelements,1)),np.conjugate([inputs['dateN']]),axis=0)
md.smb.Vz = np.tile(np.conjugate(inputs['LP']['Vz']),(md.mesh.numberofelements,1)).flatten()
md.smb.Tz = np.tile(np.conjugate(inputs['LP']['Tz']),(md.mesh.numberofelements,1)).flatten()
md.smb.Tmean = np.tile(np.conjugate(inputs['LP']['Tmean']),(md.mesh.numberofelements,1)).flatten()
md.smb.C = np.tile(np.conjugate(inputs['LP']['C']),(md.mesh.numberofelements,1)).flatten()

#smb settings
md.smb.requested_outputs = ['SmbDz','SmbT','SmbD','SmbRe','SmbGdn','SmbGsp','SmbEC','SmbA','SmbMassBalance','SmbMAdd','SmbDzAdd','SmbFAC']

#only run smb core:
md.transient.isstressbalance = 0
md.transient.ismasstransport = 0
md.transient.isthermal = 0

#time stepping:
md.timestepping.start_time = 1965.
md.timestepping.final_time = 1966.
md.timestepping.time_step = 1. / 365.0
md.timestepping.interp_forcings = 0.

#Run transient
md = solve(md,'Transient')

#Fields and tolerances to track changes
field_names      = ['SmbDz','SmbT' ,'SmbD' ,'SmbRe','SmbGdn','SmbGsp','SmbA' ,'SmbEC','SmbMassBalance','SmbMAdd','SmbDzAdd','SmbFAC']
field_tolerances = [1e-11,1e-12,1e-11,2e-11,1e-11,1e-11,1e-12,2e-12,1e-12,1e-12,1e-12,1e-11]
#shape is different in python solution (fixed using reshape) which can cause test failure:
field_values = [
	md.results.TransientSolution[-1].SmbDz[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbT[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbD[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbRe[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbGdn[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbGsp[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbA[0,0:240].reshape(1,-1),
	md.results.TransientSolution[-1].SmbEC[0],
	md.results.TransientSolution[-1].SmbMassBalance[0],
	md.results.TransientSolution[-1].SmbMAdd[0],
	md.results.TransientSolution[-1].SmbDzAdd[0],
	md.results.TransientSolution[-1].SmbFAC[0],
	]
