#Test Name: PigStressSSA2d
from model import *
from socket import gethostname
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from solve import *


md=triangle(model(),'../Exp/Pig.exp',20000.)
md=setmask(md,'../Exp/PigShelves.exp','../Exp/PigIslands.exp')
md=parameterize(md,'../Par/Pig.py')
md=setflowequation(md,'SSA','all')
md.cluster=generic('name',gethostname(),'np',3)
md=solve(md,'Stressbalance')

# Fields and tolerances to track changes
field_names     =['Vx','Vy','Vel','Pressure']
field_tolerances=[1e-12,2e-12,2e-12,1e-13]
field_values=[md.results.StressbalanceSolution.Vx,
							md.results.StressbalanceSolution.Vy,
							md.results.StressbalanceSolution.Vel,
							md.results.StressbalanceSolution.Pressure]
