function md=solveparallel(md,solutiontype,varargin)
%SOLVEPARALLEL - solution sequence using a cluster in parallel mode
%
%   Usage:
%      md=solveparallel(md,solutiontype,varargin)

%Recover type of package being used: 
if nargin==2,
	package='Ice';
else
	package=varargin{1};
end

if ~ischar(package), 
	error('Package specified in varargin can only be ''ice'', or ''cielo''');
end

if ~(strcmpi(package,'ice') || strcmpi(package,'cielo') || strcmpi(package,'macayeal'))
	error('Package specified in varargin can only be ''ice'', ''macayeal'', or ''cielo''');
end

%Get cluster.rc location
cluster_rc_location=which('cluster.rc');

%Figure out parameters for this particular cluster
[codepath,executionpath]=ClusterParameters(md.cluster,cluster_rc_location);

%Marshall model data into a binary file.
marshall(md,solutiontype,package);

%Now, we need to build the queuing script, used by the cluster to launch the job.
BuildQueueingScript(md,solutiontype,executionpath,codepath);

%Now, launch the queueing script
LaunchQueueJob(md,executionpath);

%Do we return, or just wait for results?
if md.waitonlock,
	%we wait for the done file
	waitonlock([executionpath '/' md.name '.lock']);
	%load results
	md=loadresultsfromcluster(md,solutiontype);
else
	return;
end
