function [cluster_codepath cluster_executionpath]=ClusterParameters(cluster_name,cluster_rc_location)
%CLUSTERPARAMETERS - from cluster_name, find out cluster parameters in cluster.rc file
%
%   This function reads through the cluster_rc_location file  for cluster settings (name,  
%   code location, execution directory) used to run parallel solution sequences
%
%   Usage:
%      [cluster_codepath cluster_executionpath]=ClusterParameters(cluster_name,cluster_rc_location)

lines_per_cluster=3;

%open cluster.rc file

fid=fopen(cluster_rc_location);
if fid==-1,
	error('Could not find cluster.rc file in delivery directory');
end

found=0;

%Read first line and check it starts with begin. 
line=fgetl(fid);
if ~strcmp(line,'begin'),
	error('cluster.rc file in delivery directory should always start with the begin statement');
end

%Read until we find the end statement. 
while 1
	line=fgetl(fid);
	
	%Check for 'end' statement
	if strcmp(line,'end'),
		break;
	end 
	%Check for end of file
	if ~ischar(line),
		error('cluster.rc file in delivery directory should end with an end statement');
	end
	%Ignore empty lines
	if length(line)==0,
		continue;
	end
	%Ignore comments
	if strcmp(line(1),'#'),
		continue
	end

	%Handle cluster name: 
	if length(line)>12,
		if strcmp(line(1:12),'cluster_name'),
			%ok, the next 2 lines deal with one cluster settings.
			%check if this is the cluster we are looking for.
			splittedstring=strsplit(line,'=');
			this_cluster_name=splittedstring{2};
			if strcmp(this_cluster_name,cluster_name),

				%Get next line for cluster code path
				line=fgetl(fid);
				splittedstring=strsplit(line,'=');
				descriptor=splittedstring{1};
				value=splittedstring{2};
				if ~strcmp(descriptor,'cluster_codepath'),
					error('cluster settings in cluster.rc don''t follow the correct syntax');
				end
				cluster_codepath=value;
				found=1;
				
				
				%Get next line for cluster execution path
				line=fgetl(fid);
				splittedstring=strsplit(line,'=');
				descriptor=splittedstring{1};
				value=splittedstring{2};
				if ~strcmp(descriptor,'cluster_executionpath'),
					error('cluster settings in cluster.rc don''t follow the correct syntax');
				end
				cluster_executionpath=value;

			else
				%Wrong cluster name, skip next lines_per_cluster lines and continue;
				for i=1:lines_per_cluster,
					line=fgetl(fid);
				end
				continue;
			end
		end
	end
end

fclose(fid);

if found==0,
	error(['ClusterParameters error message: could not find setting for cluster ' cluster_name ' in cluster.rc file']);
end

end %close of function
