#!/bin/bash
set -eu

#Some cleanup
rm -rf install src
mkdir install

#Download latest version
#svn co --username gmsh --password gmsh https://geuz.org/svn/gmsh/trunk src
#git clone http://gitlab.onelab.info/gmsh/gmsh.git src

#Set gmsh version
GMSH_VER="3.0.5"

#Remove tarball if it exists
rm -f gmsh-$GMSH_VER-source.tgz

#Download last stable version that we know works
wget http://gmsh.info/src/gmsh-$GMSH_VER-source.tgz

#Untar gmsh
tar -xvzf gmsh-$GMSH_VER-source.tgz

#Rename gmsh source directory
mv gmsh-$GMSH_VER-source src

#Configure
cd install
cmake ../src -DCMAKE_INSTALL_PREFIX="$ISSM_DIR/externalpackages/gmsh/install" -DENABLE_MPI=0 -DENABLE_METIS=0

#Compile and install
if [ $# -eq 0 ]; then
	make
else
	make -j $1
fi
make install
