function md=latlongfromxy(md,projection,hemisphere,merref,latref)
% LATLONGFROMXY - create latitude and longitude of the mesh
%
%   projection can be 'stereographic' only
%   hemisphere must be 'n' or 's'
%   the last two arguments are the central meridien and the zero distorsion 
%   latitude of the projection
%   
%   Usage:
%      md=latlongfromxy(md,projection,hemisphere,merref,latref)
%
%   Example
%      md=latlongfromxy(md,'stereographic','n',70,45)


%check that the hemisphere is either 'n' or 's': 
if ~(strcmpi(hemisphere,'n') | strcmpi(hemisphere,'s')),
	error('latlongfromxy error message: hemisphere should be ''s'' or ''n''');
end

if ~strcmpi(projection,'stereographic'),
	error('latlongfromxy error message: only stereographic projection implemented yet');
end

[md.lat,md.long]=mapxy(md.x,md.y,hemisphere,merref,latref);
