function levelsetnew = reinitializelevelset(md,levelset)
%REINITIALIZELEVELSET - reinitialize levelset as a signed distance function
%
%   Usage:
%      levelsetnew = reinitializelevelset(md,levelset)


%First: extract segments
contours=contourlevelzero(md,levelset,0);

%Now, make this a distance field (might not be closed)
levelsetnew=abs(ExpToLevelSet(md.mesh.x,md.mesh.y,contours));

%Finally, change sign
pos = find(levelset<0);
levelsetnew(pos) = -levelsetnew(pos);
