from fielddisplay import fielddisplay
from checkfield import checkfield
from WriteData import WriteData

class calvingminthickness(object):
	"""
	CALVINGMINTHICKNESS class definition

	   Usage:
	      calvingminthickness=calvingminthickness()
	"""

	def __init__(self): # {{{

		self.min_thickness = 0.
		self.meltingrate   = float('NaN')

		#set defaults
		self.setdefaultparameters()

	#}}}
	def __repr__(self): # {{{
		string='   Calving Minimum thickness:'
		string="%s\n%s"%(string,fielddisplay(self,'min_thickness','minimum thickness below which no ice is allowed'))
		string="%s\n%s"%(string,fielddisplay(self,'meltingrate','melting rate at given location [m/a]'))
		return string
	#}}}
	def extrude(self,md): # {{{
		self.meltingrate=project3d(md,'vector',self.meltingrate,'type','node')
		return self
	#}}}
	def setdefaultparameters(self): # {{{

		#minimum thickness is 100 m by default
		self.min_thickness = 100.
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if solution == 'TransientSolution' or md.transient.ismovingfront == 0:
			return

		md = checkfield(md,'fieldname','calving.min_thickness','>',0,'NaN',1,'Inf',1)
		md = checkfield(md,'fieldname','calving.meltingrate','NaN',1,'Inf',1,'size',[md.mesh.numberofvertices],'>=',0)
		return md
	# }}}
	def marshall(self,prefix,md,fid):    # {{{
		yts=md.constants.yts
		WriteData(fid,prefix,'name','md.calving.law','data',4,'format','Integer')
		WriteData(fid,prefix,'object',self,'fieldname','min_thickness','format','Double')
		WriteData(fid,prefix,'object',self,'fieldname','meltingrate','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'scale',1./yts)
	# }}}
