/*!\file Profiler.h
 * \brief: header file for node object
 */

#ifndef _PROFILER_H_
#define _PROFILER_H_

/*Headers:*/
#include "../shared/shared.h"
#include "../datastructures/datastructures.h"

/*Macros*/
#define TOTAL 0      /*Profiling Total time */ 
#define MPROCESSOR 1 /*Profiling Model processor*/ 
#define CORE 2       /*Profiling solution */ 
#define SOLVER 3     /*Profiling solution */ 
#define ADCORE 4     /*Profiling AD */ 
#define MAXIMUMSIZE 5

class Profiler: public Object{

	public: 
		IssmPDouble flops[MAXIMUMSIZE];
		IssmPDouble flops_start[MAXIMUMSIZE];
		IssmPDouble memory[MAXIMUMSIZE];
		IssmPDouble memory_start[MAXIMUMSIZE];
		IssmPDouble time[MAXIMUMSIZE];
		IssmPDouble time_start[MAXIMUMSIZE];
		bool        running[MAXIMUMSIZE];

		/*Profiler constructors, destructors */
		Profiler();
		~Profiler();

		/*Object virtual functions definitions*/
		Object *copy();
		void    DeepEcho();
		void    Echo();
		int     Id();
		void    Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int     ObjectEnum();

		/*Profiler routines*/
		IssmPDouble  TotalFlops(int tag);
		IssmPDouble  TotalTime(int tag);
		int          TotalTimeModHour(int tag);
		int          TotalTimeModMin(int tag);
		int          TotalTimeModSec(int tag);
		IssmPDouble  Memory(int tag);
		void         Start(int tagenum,bool dontmpisync=false);
		void         Stop(int tagenum,bool dontmpisync=false);
};

#endif  /* _PROFILER_H_ */
