#!/bin/bash

STEP=2

if [ $STEP -eq 1 ]; then
	rm -rf src
	git clone https://bitbucket.org/petsc/petsc src
fi

# To update 
#      cd src
#      git pull

# configure script
# Note: 
# SuperLU: -If download-..-=yes does not work try downloading from
#    --download-superlu=http://crd.lbl.gov/~xiaoye/SuperLU/superlu_4.3.tar.gz \


if [ $STEP -eq 2 ]; then
	rm -rf install
	cd src
	./configure \
		--prefix="$ISSM_DIR/externalpackages/petsc/install" \
		--with-mpi-dir="$ISSM_DIR/externalpackages/mpich/install" \
		--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
		--with-debugging=1 \
		--with-valgrind=0 \
		--with-x=0 \
		--with-ssl=0 \
		--with-shared-libraries=1 \
		--download-metis=1 \
		--download-parmetis=1 \
		--download-mumps=1 \
		--download-scalapack=1 \
		--download-fblaslapack=1 \
		--with-pic=1

#	--download-trilinos=yes \
#	--download-euclid=yes \
#	--download-spooles=yes \
#	--download-spai=yes \
#	--download-superlu=http://crd.lbl.gov/~xiaoye/SuperLU/superlu_4.3.tar.gz \
#	--download-hypre=yes \

	#Compile petsc and install it
	make
	make install
fi
