/*!\file SetControlInputsFromVectorx
 * \brief retrieve vector from inputs in elements
 */

#include "./SetControlInputsFromVectorx.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"

void SetControlInputsFromVectorx(FemModel* femmodel,IssmDouble* vector){

	bool isautodiff; 
	femmodel->parameters->FindParam(&isautodiff,AutodiffIsautodiffEnum);
	if(isautodiff){
		int  num_controls;
		int* control_type = NULL;
		int* M = NULL;
		int* N = NULL;

		/*Retrieve some parameters*/
		femmodel->parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
		femmodel->parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);
		femmodel->parameters->FindParam(&M,NULL,ControlInputSizeMEnum);
		femmodel->parameters->FindParam(&N,NULL,ControlInputSizeNEnum);

		int offset = 0;
		for(int i=0;i<num_controls;i++){
			for(int j=0;j<femmodel->elements->Size();j++){
				Element* element=(Element*)femmodel->elements->GetObjectByOffset(j);
				element->SetControlInputsFromVector(vector,control_type[i],i,offset,N[i],M[i]);
			}
		offset += M[i]*N[i]; 
		}


		xDelete<int>(control_type);
	}
	else{

		int  num_controls;
		int* control_type = NULL;
		femmodel->parameters->FindParam(&num_controls,InversionNumControlParametersEnum);
		femmodel->parameters->FindParam(&control_type,NULL,InversionControlParametersEnum);
		int offset = 0;
		for(int i=0;i<num_controls;i++){
			for(int j=0;j<femmodel->elements->Size();j++){
				Element* element=(Element*)femmodel->elements->GetObjectByOffset(j);
				element->SetControlInputsFromVector(vector,control_type[i],i);
			}
		}
		xDelete<int>(control_type);
	}
}

void SetControlInputsFromVectorx(FemModel* femmodel,Vector<IssmDouble>* vector){

	IssmDouble* serial_vector=vector->ToMPISerial();
	SetControlInputsFromVectorx(femmodel,serial_vector);
	xDelete<IssmDouble>(serial_vector);
}
