function new_data=stereomap(x_m,y_m,data,slat,xhem,new_x_m,new_y_m,new_slat,new_xhem,hemisphere);
%STEREOMAP take a 2d map, on a stereographic projection defined by (slat, xhem), 
%          and remap it to a new projection (on 2d axis (new_x_m,new_y_m) and new_slat,new_xhem,hemisphere)
%
%   usage: new_data=stereomap(x_m,y_m,data,slat,xhem,new_x_m,new_y_m,new_slat,new_xhem,hemisphere);
%
%   see also: mapll and mapxy

M=length(new_y_m)-1;
N=length(new_x_m)-1;

%First, transform (new_x_m,new_y_m) into current projection: 
x=zeros(M*N,1);
y=zeros(M*N,1);
for i=1:M,
	x( (i-1)*N+1:i*N)=(new_x_m(1:end-1)+new_x_m(2:end))/2;
	y( (i-1)*N+1:i*N)=(new_y_m(i)+new_y_m(i+1))/2*ones(N,1);
end

[lat,long]=mapxy(x,y,hemisphere,new_slat,new_xhem);
[new_x,new_y]=mapll(lat,long,hemisphere,slat,xhem);

%ok, we have the transformed coordinates in the current projection, go pick up the corresponding 
%values.
new_data_line=InterpFromGrid(x_m,y_m,data,new_x,new_y,NaN);

new_data=zeros(M,N);
for i=1:M,
	new_data(i,:)=new_data_line( (i-1)*N+1:i*N);
end
