function  [x,y]=mapll(lat,lon,hem,varargin);
%MAPLL - convert latitude and longitude into x and y
%
%   latitude and longitude are in degrees.
%   Hemisphere must be 1 for north and 0 for south
%
%   Usage:
%      [x,y]=mapll(latitude,longitude,hemisphere)
%
%   See also MAPXY, LL2XY

%check number of arguments.
if ~((nargin==3) | (nargin==5)),
	mapllerrorusage();
end

%hem: must be either 's' or 'n'
if ~ischar(hem),
	error('mapll error message: hemisphere argument should be ''n'' or ''s''');
end

%check hem is either 'n' or 's': 
if ~(hem=='s' | hem=='n'),
	error('mapll error message: hem should be ''s'' or ''n''');
end

%set sn: 
if hem=='s',
	slat=71;
	sn=-1.0;
	xlam=0;
else
	slat=70;
	sn=1.0;
	xlam=45;
end

%set defaults for standard parallels and centre meridians.
if nargin==5,
	slat=varargin{1};
	xlam=varargin{2};
end


%some corrections
lon=lon+360;       % to have 0<lon<360

%WGS84
re=6378137.0;
e2= 0.00669437999015;
e=sqrt(e2);

lat=sn*lat*pi/180;
lon=lon*pi/180;

rlat=lat;
slat=slat/180*pi;
xlam=xlam/180*pi;

t1=tan(pi/4.-rlat/2.)./((1.0-e*sin(rlat))./...
(1.0+e*sin(rlat))).^(e/2.);

t2=tan(pi/4.-slat/2.)./((1.0-e*sin(slat))./...
(1.0+e*sin(slat))).^(e/2.);

cm=cos(slat)./sqrt(1.0-e2*(sin(slat).^2));
rho=re*cm.*t1./t2;
x= rho*sn.*sin((lon+xlam));
y=-rho*sn.*cos((lon+xlam));

end

function mapllerrorusage(),
	help mapll
end
