function [x,y]=ll2xy(lat,lon);
%LL2XY - convert latitude and longitude coordinates to x and y
%
%   Usage:
%      [x,y]=ll2xy(lat,lon)
%
%   See also MAPLL, MAPXY

lon=lon+360; % to have 0<lon<360

re = 6378137.0; 	% WGS84
e2 = 0.00669437999015;  % WGS84
sn=+1.0; 	% because it's southern hemisphere

a=re;
e=sqrt(e2);

phi  = sn*lat*pi/180;
lambda  = lon*pi/180; 

qp = 1 - (1-e2)/2/e*log((1-e)/(1+e));
%m=cos(phi)/sqrt(1-e2.*sin(phi)*sin(phi));
q=(1-e2)*(sin(phi)./(1-e2*sin(phi).^2)-0.5/e*log((1-e*sin(phi))./(1+e*sin(phi))));
rho = a*sqrt(qp-q);
x = rho.*sin(lambda);
y = - sn*rho.*cos(lambda);


%lon=lon-360; % to recover the initial longitude

