function md=steadystate(md);
%STEADYSTATE - compute the velocity and temperature field of a model in steady state.
%
%   Usage:
%      md=steadystate(md)
%

	%timing
	t1=clock;

	models.analysis_type=SteadystateAnalysisEnum; %needed for processresults
	
	%Build all models requested for diagnostic simulation
	displaystring(md.debug,'%s',['reading diagnostic horiz model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=HorizAnalysisEnum; models.dh=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading diagnostic vert model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=VertAnalysisEnum; models.dv=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading diagnostic stokes model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=StokesAnalysisEnum; models.ds=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading diagnostic hutter model data']);
	md.analysis_type=DiagnosticAnalysisEnum; md.sub_analysis_type=HutterAnalysisEnum; models.dhu=CreateFemModel(md);
	
	displaystring(md.debug,'\n%s',['reading surface and bed slope computation model data']);
	md.analysis_type=SlopeComputeAnalysisEnum; md.sub_analysis_type=NoneAnalysisEnum; models.sl=CreateFemModel(md);

	%Build all models requested for thermal simulation
	displaystring(md.debug,'%s',['reading thermal model data']);
	md.analysis_type=ThermalAnalysisEnum(); md.sub_analysis_type=NoneAnalysisEnum(); models.t=CreateFemModel(md);

	displaystring(md.debug,'%s',['reading melting model data']);
	md.analysis_type=MeltingAnalysisEnum(); md.sub_analysis_type=NoneAnalysisEnum(); models.m=CreateFemModel(md);

	% figure out number of dof: just for information purposes.
	md.dof=modelsize(models);

	%initialize inputs
	displaystring(md.debug,'\n%s',['setup inputs...']);
	inputs=inputlist;
	inputs=add(inputs,'velocity',models.dh.parameters.u_g,'doublevec',3,models.dh.parameters.numberofnodes);
	inputs=add(inputs,'pressure',models.t.parameters.p_g,'doublevec',1,models.t.parameters.numberofnodes);
	inputs=add(inputs,'dt',models.t.parameters.dt*models.t.parameters.yts,'double');
	if md.control_analysis,
		inputs=add(inputs,'cm_noisedampening',models.dh.parameters.cm_noisedampening,'double');
		inputs=add(inputs,'velocity_obs',models.dh.parameters.u_g_obs,'doublevec',2,models.dh.parameters.numberofnodes);
	end
	
	%compute solution
	if ~models.dh.parameters.qmu_analysis,
		if md.control_analysis,
			%change control_steady to 1
			models.dh.parameters.control_steady=1;
			models.ds.parameters.control_steady=1;
			%launch core of control solution.
			results=control_core(models,inputs);

			%process results
			if ~isstruct(md.results), md.results=struct(); end
			md.results.steadystate=processresults(models,results);
		else,
			%launch core of steadystate solution.
			results=steadystate_core(models,inputs);
		
			%process results
			if ~isstruct(md.results), md.results=struct(); end
			md.results.steadystate=processresults(models,results);
		end
	else
		%launch dakota driver for steadystate core solution
		Qmu(models,inputs,models.dh.parameters);
	end

	%stop timing
	t2=clock;
	displaystring(md.debug,'\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']);
