/*!\file: CreateParametersControl.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#undef __FUNCT__ 
#define __FUNCT__ "CreateParameters"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../IoModel.h"

void CreateParametersControl(DataSet** pparameters,IoModel* iomodel,ConstDataHandle iomodel_handle){
	
	int i;
	
	DataSet* parameters=NULL;
	Param*   param = NULL;
	int      count;
	int      analysis_type;
	int      numberofdofspernode;

	double* fit=NULL;
	double* cm_jump=NULL;
	double* optscal=NULL;
	double* maxiter=NULL; 
	double* control_parameter=NULL;
	double* param_g=NULL;

	double* vx_obs=NULL;
	double* vy_obs=NULL;
	double* u_g_obs=NULL;

	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	double* u_g=NULL;

	/*Get parameters: */
	parameters=*pparameters;
	count=parameters->Size();
	
	//control analysis?
	count++;
	param= new Param(count,"control_analysis",INTEGER);
	param->SetInteger(iomodel->control_analysis);
	parameters->AddObject(param);
	
	if(iomodel->control_analysis){
		/*control_type: */
		count++;
		param= new Param(count,"control_type",STRING);
		param->SetString(iomodel->control_type);
		parameters->AddObject(param);

		/*extrude_param: */
		count++;
		param= new Param(count,"extrude_param",DOUBLE);
		if (strcmp(iomodel->control_type,"drag")==0)   param->SetDouble(0);
		else if (strcmp(iomodel->control_type,"B")==0) param->SetDouble(1);
		else throw ErrorException(__FUNCT__,exprintf("control_type %s not supported yet!",iomodel->control_type));
		parameters->AddObject(param);

		/*control_steady: */
		count++;
		param= new Param(count,"control_steady",INTEGER);
		param->SetInteger(0);
		parameters->AddObject(param);

		/*nsteps: */
		count++;
		param= new Param(count,"nsteps",INTEGER);
		param->SetInteger(iomodel->nsteps);
		parameters->AddObject(param);

		/*tolx: */
		count++;
		param= new Param(count,"tolx",DOUBLE);
		param->SetDouble(iomodel->tolx);
		parameters->AddObject(param);

		/*eps_cm: */
		count++;
		param= new Param(count,"eps_cm",DOUBLE);
		param->SetDouble(iomodel->eps_cm);
		parameters->AddObject(param);

		/*cm_noisedampening: */
		count++;
		param= new Param(count,"cm_noisedampening",DOUBLE);
		param->SetDouble(iomodel->cm_noisedampening);
		parameters->AddObject(param);

		/*mincontrolconstraint: */
		count++;
		param= new Param(count,"mincontrolconstraint",DOUBLE);
		param->SetDouble(iomodel->mincontrolconstraint);
		parameters->AddObject(param);

		/*maxcontrolconstraint: */
		count++;
		param= new Param(count,"maxcontrolconstraint",DOUBLE);
		param->SetDouble(iomodel->maxcontrolconstraint);
		parameters->AddObject(param);
		
		/*epsvel: */
		count++;
		param= new Param(count,"epsvel",DOUBLE);
		param->SetDouble(iomodel->epsvel);
		parameters->AddObject(param);
		
		/*meanvel: */
		count++;
		param= new Param(count,"meanvel",DOUBLE);
		param->SetDouble(iomodel->meanvel);
		parameters->AddObject(param);

		/*Now, recover fit, optscal and maxiter as vectors: */
		IoModelFetchData((void**)&iomodel->fit,NULL,NULL,iomodel_handle,"fit","Matrix","Mat");
		IoModelFetchData((void**)&iomodel->cm_jump,NULL,NULL,iomodel_handle,"cm_jump","Matrix","Mat");
		IoModelFetchData((void**)&iomodel->optscal,NULL,NULL,iomodel_handle,"optscal","Matrix","Mat");
		IoModelFetchData((void**)&iomodel->maxiter,NULL,NULL,iomodel_handle,"maxiter","Matrix","Mat");

		count++;
		param= new Param(count,"fit",DOUBLEVEC);
		param->SetDoubleVec(iomodel->fit,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"cm_jump",DOUBLEVEC);
		param->SetDoubleVec(iomodel->cm_jump,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"optscal",DOUBLEVEC);
		param->SetDoubleVec(iomodel->optscal,iomodel->nsteps);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"maxiter",DOUBLEVEC);
		param->SetDoubleVec(iomodel->maxiter,iomodel->nsteps);
		parameters->AddObject(param);

		xfree((void**)&iomodel->fit);
		xfree((void**)&iomodel->cm_jump);
		xfree((void**)&iomodel->optscal);
		xfree((void**)&iomodel->maxiter);

		/*Get vx, vx_obs, vy, vy_obs, and the parameter value: */
		IoModelFetchData((void**)&vx,NULL,NULL,iomodel_handle,"vx","Matrix","Mat");
		IoModelFetchData((void**)&vy,NULL,NULL,iomodel_handle,"vy","Matrix","Mat");
		IoModelFetchData((void**)&vz,NULL,NULL,iomodel_handle,"vz","Matrix","Mat");
		IoModelFetchData((void**)&vx_obs,NULL,NULL,iomodel_handle,"vx_obs","Matrix","Mat");
		IoModelFetchData((void**)&vy_obs,NULL,NULL,iomodel_handle,"vy_obs","Matrix","Mat");
		IoModelFetchData((void**)&control_parameter,NULL,NULL,iomodel_handle,iomodel->control_type,"Matrix","Mat");

		u_g=(double*)xcalloc(iomodel->numberofnodes*3,sizeof(double));
		if(vx)for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+0]=vx[i]/iomodel->yts;
		if(vy)for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+1]=vy[i]/iomodel->yts;
		if(vz)for(i=0;i<iomodel->numberofnodes;i++)u_g[3*i+2]=vz[i]/iomodel->yts;

		count++;
		param= new Param(count,"u_g",DOUBLEVEC);
		param->SetDoubleVec(u_g,3*iomodel->numberofnodes,3);
		parameters->AddObject(param);

		u_g_obs=(double*)xcalloc(iomodel->numberofnodes*2,sizeof(double));
		if(vx_obs)for(i=0;i<iomodel->numberofnodes;i++)u_g_obs[2*i+0]=vx_obs[i]/iomodel->yts;
		if(vy_obs)for(i=0;i<iomodel->numberofnodes;i++)u_g_obs[2*i+1]=vy_obs[i]/iomodel->yts;

		count++;
		param= new Param(count,"u_g_obs",DOUBLEVEC);
		param->SetDoubleVec(u_g_obs,2*iomodel->numberofnodes,2);
		parameters->AddObject(param);
		
		param_g=(double*)xcalloc(iomodel->numberofnodes,sizeof(double));
		for(i=0;i<iomodel->numberofnodes;i++)param_g[i]=control_parameter[i];

		count++;
		param= new Param(count,"param_g",DOUBLEVEC);
		param->SetDoubleVec(param_g,iomodel->numberofnodes,1);
		parameters->AddObject(param);

		xfree((void**)&vx);
		xfree((void**)&vy);
		xfree((void**)&vz);
		xfree((void**)&u_g);
		xfree((void**)&vx_obs);
		xfree((void**)&vy_obs);
		xfree((void**)&u_g_obs);
		xfree((void**)&param_g);
		xfree((void**)&control_parameter);
	}

	/*Assign output pointer: */
	*pparameters=parameters;
}
