function BuildQueueingScriptcosmos(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptcosmos(md,executionpath,codepath)

scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptcosmos error message: could not open ' scriptname ' file for ascii writing']);
end

%check queue names: 
available_queues={'debug','shortq','longq','specialq'};
if  ~ismemberi(md.queue,available_queues),
	error('BuildQueueingScriptcosmos error message: availables queues are debug, shortq, longq and specialq');
end

%test parameters for each queue: 
if strcmpi(md.queue,'debug'),
	if md.np>32,
		error('BuildQueueingScriptcosmos error message: debug queue only allows 32 cpus');
	end
	if md.time>60,
		error('BuildQueueingScriptcosmos error message: debug queue only allows 60 minutes');
	end
end

if strcmpi(md.queue,'shortq'),
	if md.np>128,
		error('BuildQueueingScriptcosmos error message: shortq queue only allows 128 cpus');
	end
	if md.time>180,
		error('BuildQueueingScriptcosmos error message: shortq queue only allows 180 minutes');
	end
end

if strcmpi(md.queue,'longq'),
	if md.np>128,
		error('BuildQueueingScriptcosmos error message: longq queue only allows 128 cpus');
	end
	if md.time>720,
		error('BuildQueueingScriptcosmos error message: longq queue only allows 720 minutes');
	end
end

if strcmpi(md.queue,'specialq'),
	if md.np>10,
		error('BuildQueueingScriptcosmos error message: longq queue only allows 10 cpus');
	end
end



fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'#PBS -l select=%i:ncpus=1\n',md.np);
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.
if ~isempty(md.queue),
	fprintf(fid,'#PBS -q %s\n',md.queue);
end
fprintf(fid,'#PBS -o %s.outlog \n',md.name);
fprintf(fid,'#PBS -e %s.errlog \n',md.name);

fprintf(fid,'setenv PBS_O_WORKDIR %s\n',executionpath);
fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'setenv OMP_NUM_THREADS 1\n');
fprintf(fid,'limit stacksize unlimited\n');
fprintf(fid,'limit coredumpsize 0\n');
fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpirun -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock',md.np,codepath,AnalysisTypeFromEnum(md.analysis_type),executionpath,md.name,md.name,md.name);
fclose(fid);
