/*!\file Cfdragcoeffabsgrad.h
 * \brief: header file for Cfdragcoeffabsgrad object
 */

#ifndef _CFDRAGCOEFFABSGRAD_H_
#define _CFDRAGCOEFFABSGRAD_H_

/*Headers:*/
#include "./Definition.h"
#include "./FemModel.h"

IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);
void  GetVectorFromInputsx( IssmDouble** pvector, int* pvector_size, FemModel* femmodel,int name);

class Cfdragcoeffabsgrad: public Object, public Definition{

	public: 

		int         definitionenum;
		char*       name;
		int         weights_enum;
		IssmDouble	datatime;
		bool			timepassedflag;
		IssmDouble	last_time;
		
		int         lock; // if lock is on, we just return the value stored in "misfit".  this is used so we don't compute misfit past the final_time
		IssmDouble  misfit; //value carried over in time.
		
		/*Cfdragcoeffabsgrad constructors, destructors :*/
		Cfdragcoeffabsgrad();
		Cfdragcoeffabsgrad(char* in_name, int in_definitionenum, int in_weights_enum, IssmDouble in_datatime, bool timepassedflag);
		~Cfdragcoeffabsgrad();
		
		/*Object virtual function resolutoin: */
		Object* copy();
		void DeepEcho(void);
		void Echo(void);
		int Id(void);
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int ObjectEnum(void);
		
		/*Definition virtual function resolutoin: */
		int DefinitionEnum();
		char* Name();
		IssmDouble Response(FemModel* femmodel);
		IssmDouble Cfdragcoeffabsgrad_Calculation(Element* element, int weights_enum);
};
#endif  /* _CFDRAGCOEFFABSGRAD_H_ */
