/*
 * \file Inputs.c
 * \brief: implementation of the Inputs class, derived from DataSet class
 */

/*Headers: {{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./Input.h"
#include "./Inputs.h"
#include "../../shared/shared.h"

using namespace std;
/*}}}*/

/*Object constructors and destructor*/
Inputs::Inputs(){/*{{{*/
	return;
}
/*}}}*/
Inputs::~Inputs(){/*{{{*/
	return;
}
/*}}}*/

/*Object management*/
int  Inputs::AddInput(Input* in_input){/*{{{*/

	_assert_(in_input); 

	/*Delete input if it already exists*/
	this->DeleteInput(in_input->InstanceEnum());

	/*Now add new input to the dataset*/
	this->AddObject(in_input);

	return 1;
}
/*}}}*/
void  Inputs::ChangeEnum(int oldenumtype,int newenumtype){/*{{{*/

	/*Delete input if it already exists*/
	this->DeleteInput(newenumtype);

	/*Now get old input and change its enum (do not error out if not found)*/
	Input* input=this->GetInput(oldenumtype);
	if(input) input->ChangeEnum(newenumtype);
}/*}}}*/
void Inputs::Configure(Parameters* parameters){/*{{{*/

	vector<Object*>::iterator object;
	Input* input=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){

		input=xDynamicCast<Input*>(*object);
		input->Configure(parameters);

	}

}
/*}}}*/
int  Inputs::DeleteInput(int enum_type){/*{{{*/

	Input* input=this->GetInput(enum_type);
	if(input) this->DeleteObject(input);
	return 1;

}
/*}}}*/
void  Inputs::DuplicateInput(int original_enum,int new_enum){/*{{{*/

	/*Make a copy of the original input: */
	Input* original=this->GetInput(original_enum);
	if(!original)_error_("could not find input with enum: " << EnumToStringx(original_enum)); 
	Input* copy=xDynamicCast<Input*>(original->copy());

	/*Change copy enum to reinitialized_enum: */
	copy->ChangeEnum(new_enum);

	/*Add copy into inputs, it will wipe off the one already there: */
	this->AddInput(xDynamicCast<Input*>(copy));
}
/*}}}*/
Input* Inputs::GetInput(int enum_name){/*{{{*/

	vector<Object*>::iterator object;
	Input* input=NULL;

	for ( object=objects.begin() ; object < objects.end(); object++ ){
		input=xDynamicCast<Input*>(*object);
		if (input->InstanceEnum()==enum_name) return input;
	}

	return NULL;
}
/*}}}*/
void Inputs::GetInputAverage(IssmDouble* pvalue,int enum_type){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enum_type);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetInputAverage(pvalue);

}
/*}}}*/
void Inputs::GetInputValue(bool* pvalue,int enum_type){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enum_type);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetInputValue(pvalue);

}
/*}}}*/
void Inputs::GetInputValue(int* pvalue,int enum_type){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enum_type);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetInputValue(pvalue);

}/*}}}*/
void Inputs::GetInputValue(IssmDouble* pvalue,int enum_type){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enum_type);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Ok, we have an input if we made it here, request the input to return the value: */
	input->GetInputValue(pvalue);

}/*}}}*/
IssmDouble Inputs::Max(int enumtype){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enumtype);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Return output*/
	return input->Max();

}/*}}}*/
IssmDouble Inputs::MaxAbs(int enumtype){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enumtype);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Return output*/
	return input->MaxAbs();

}/*}}}*/
IssmDouble Inputs::Min(int enumtype){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enumtype);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Return output*/
	return input->Min();

}/*}}}*/
IssmDouble Inputs::MinAbs(int enumtype){/*{{{*/

	/*Find input in current dataset*/
	Input* input=this->GetInput(enumtype);
	if (!input) _error_("could not find input with enum type " << enum_type << " (" << EnumToStringx(enum_type) << ")");

	/*Return output*/
	return input->MinAbs();

}/*}}}*/
Inputs* Inputs::SpawnSegInputs(int index1,int index2){/*{{{*/

	/*Intermediary*/
	vector<Object*>::iterator object;
	Input* inputin=NULL;
	Input* inputout=NULL;

	/*Output*/
	Inputs* newinputs=new Inputs();

	/*Go through inputs and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new input*/
		inputin=xDynamicCast<Input*>(*object);
		inputout=inputin->SpawnSegInput(index1,index2);

		/*Add input to new inputs*/
		newinputs->AddObject(inputout);
	}

	/*Assign output pointer*/
	return newinputs;
}
/*}}}*/
Inputs* Inputs::SpawnTriaInputs(int index1,int index2,int index3){/*{{{*/

	/*Intermediary*/
	vector<Object*>::iterator object;
	Input* inputin=NULL;
	Input* inputout=NULL;

	/*Output*/
	Inputs* newinputs=new Inputs();

	/*Go through inputs and call Spawn function*/
	for ( object=objects.begin() ; object < objects.end(); object++ ){

		/*Create new input*/
		inputin=xDynamicCast<Input*>(*object);
		inputout=inputin->SpawnTriaInput(index1,index2,index3);

		/*Add input to new inputs*/
		newinputs->AddObject(inputout);
	}

	/*Assign output pointer*/
	return newinputs;
}
/*}}}*/
