function BuildQueueingScriptgemini(md,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGEMINI - ...
%
%   Usage:
%      BuildQueueingScriptgemini(md,executionpath,codepath)

scriptname=[md.name '.queue'];



%check queue names: 
if strcmpi(md.cluster,'gemini'),
	available_queues={'debug','shortg','longg'};
	if  ~ismemberi(md.queue,available_queues),
		error('BuildQueueingScriptcosmos error message: availables queues are debug, shortg and longg');
	end 

	if strcmpi(md.queue,'debug'),
		if md.np>50,
			error('BuildQueueingScriptgeminierror error message: debug queue only allows for 50 cpus max');
		end
		
		if md.time>60,
			error('BuildQueueingScriptgeminierror error message: debug queue only allows for 60 minute runs');
		end
	end
end

if strcmpi(md.cluster,'castor'),
	available_queues={'shortc','longc'};
	if  ~ismemberi(md.queue,available_queues),
		error('BuildQueueingScriptcosmos error message: availables queues are shortc and longc');
	end 
end

if strcmpi(md.cluster,'pollux'),
	available_queues={'shortp','longp'};
	if  ~ismemberi(md.queue,available_queues),
		error('BuildQueueingScriptcosmos error message: availables queues are shortp and longp');
	end 
end

%test parameters valid for all queues
if strcmpi(md.queue(1:5),'short'),
	if md.np>128,
		error('BuildQueueingScriptcosmos error message: short queue only allows 128 cpus');
	end
	if md.time>180,
		error('BuildQueueingScriptcosmos error message: short queue only allows 180 minutes');
	end
end

if strcmpi(md.queue(1:4),'long'),
	if md.np>128,
		error('BuildQueueingScriptcosmos error message: long queue only allows 128 cpus');
	end
	if md.time>720,
		error('BuildQueueingScriptcosmos error message: long queue only allows 720 minutes');
	end
end

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptgeminierror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'#PBS -l walltime=%i\n',md.time*60); %walltime is in seconds.
fprintf(fid,'#PBS -l ncpus=%i\n',md.np);
if ~isempty(md.queue),
	fprintf(fid,'#PBS -q %s\n',md.queue);
end
fprintf(fid,'#PBS -o %s.outlog \n',md.name);
fprintf(fid,'#PBS -e %s.errlog \n',md.name);

fprintf(fid,'export PBS_O_WORKDIR=%s\n',executionpath);
fprintf(fid,'cd $PBS_O_WORKDIR\n');
fprintf(fid,'export OMP_NUM_THREADS=1\n');
fprintf(fid,'dplace -s1 -c0-%i mpirun -np %i %s/%s.exe %s %s.bin %s.outbin %s.lock',md.np-1,md.np,codepath,AnalysisTypeFromEnum(md.analysis_type),executionpath,md.name,md.name,md.name);

fclose(fid);
