/*!\file Cfsurfacelogvel.h
 * \brief: header file for Cfsurfacelogvel object
 */

#ifndef _CFSURFACESQUARE_H_
#define _CFSURFACESQUARE_H_

/*Headers:*/
#include "./Definition.h"
#include "./FemModel.h"

IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);
void  GetVectorFromInputsx( IssmDouble** pvector, int* pvector_size, FemModel* femmodel,int name);

class Cfsurfacelogvel: public Object, public Definition{

	public: 

		int         definitionenum;
		char*       name;
		IssmDouble	datatime;
		bool			timepassedflag;
		
		int         lock; // if lock is on, we just return the value stored in "misfit".  this is used so we don't compute misfit past the final_time
		IssmDouble  misfit; //value carried over in time.
		
		/*Cfsurfacelogvel constructors, destructors :*/
		Cfsurfacelogvel();
		Cfsurfacelogvel(char* in_name, int in_definitionenum, IssmDouble in_datatime, bool timepassedflag);
		~Cfsurfacelogvel();
		
		/*Object virtual function resolutoin: */
		Object* copy();
		void DeepEcho(void);
		void Echo(void);
		int Id(void);
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction);
		int ObjectEnum(void);
		
		/*Definition virtual function resolutoin: */
		int DefinitionEnum();
		char* Name();
		IssmDouble Response(FemModel* femmodel);
		IssmDouble Cfsurfacelogvel_Calculation(Element* element, int definitionenum);
};
#endif  /* _CFSURFACESQUARE_H_ */
