#ISSM_DIR and ISSM_ARCH should have been defined already in your shell settings file (.bashrc, .cshrc, etc ...)
source $ISSM_DIR/etc/environment_variables.csh

#Do we have any command line arguments? (such as MATLAB_DIR=otherdirthandefault), source them before exporting the variables 
#to environment.

#foreach i ($@)
#eval $i
#end

#CRON utilities
setenv PATH {$PATH}:{$ISSM_DIR}/cron

#SCRIPTS utilities
setenv PATH {$PATH}:{$ISSM_DIR}/scripts

#MATLAB
setenv MATLAB_DIR {$MATLAB_DIR}
setenv PATH {$PATH}:{$MATLAB_DIR}/bin

#MPI
setenv MPI_DIR {$MPI_DIR}
setenv PATH {$PATH}:{$MPI_DIR}/bin
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$MPI_DIR/lib
setenv MANPATH {$MANPATH}:$MPI_DIR/man
setenv MPIRUN_NPROCS 8

#PETSC
setenv PETSC_DIR {$PETSC_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$PETSC_DIR/lib/{$ISSM_ARCH}

#SLEPC
setenv SLEPC_DIR {$SLEPC_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:$SLEPC_DIR/lib/{$ISSM_ARCH}


#Dakota
setenv DAKOTA_DIR {$DAKOTA_DIR}
setenv PATH {$PATH}:{$DAKOTA_DIR}/bin
setenv MANPATH {$MANPATH}:{$MPI_DIR}/man:{$DAKOTA_DIR}/docs/man:{$DAKOTA_DIR}/docs/man-ref

#Qhull
setenv QHULL_DIR {$QHULL_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$QHULL_DIR}/lib


#Doxygen
setenv DOXYGEN_DIR {$DOXYGEN_DIR}
setenv MANPATH {$MANPATH}:{$DOXYGEN_DIR}/man
setenv PATH {$PATH}:{$DOXYGEN_DIR}/bin

#MTOC
setenv MTOC_DIR {$MTOC_DIR}
setenv PATH {$PATH}:{$MTOC_DIR}

#MATLAB
setenv MATLAB_DIR {$MATLAB_DIR}
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$MATLAB_DIR}/bin/glnxa64
setenv PATH {$PATH}:{$MATLAB_DIR}/bin

#TRIANGLE
setenv TRIANGLE_DIR {$TRIANGLE_DIR}

#METIS
setenv METIS_DIR {$METIS_DIR}
	
#BLAS
setenv BLAS_DIR {$BLAS_DIR}

#LAPACK
setenv LAPACK_DIR {$LAPACK_DIR}

#SCALAPACK
setenv SCALAPACK_DIR {$SCALAPACK_DIR}

#PLAPACK
setenv PLAPACK_DIR {$PLAPACK_DIR}

#BLACS
setenv BLACS_DIR {$BLACS_DIR}

#YAMS
setenv YAMS_DIR {$YAMS_DIR}
setenv PATH {$PATH}:{$YAMS_DIR}

#TEX2IM
setenv TEX2IM_DIR {$TEX2IM_DIR}
setenv PATH {$PATH}:{$TEX2IM_DIR}

#SOWING
setenv SOWING_DIR {$SOWING_DIR}
setenv PATH {$PATH}:{$SOWING_DIR}/bin
setenv LD_LIBRARY_PATH {$LD_LIBRARY_PATH}:{$SOWING_DIR}/lib
setenv MANPATH {$MANPATH}:{$SOWING_DIR}/man

#AUTOCONF
setenv AUTOCONF_DIR {$AUTOCONF_DIR}
setenv PATH {$PATH}:{$AUTOCONF_DIR}/bin

#AUTOMAKE
setenv AUTOMAKE_DIR {$AUTOMAKE_DIR}
setenv PATH {$PATH}:{$AUTOMAKE_DIR}/bin

#BORLAND
setenv BORLAND_DIR {$BORLAND_DIR}
setenv PATH {$PATH}:{$BORLAND_DIR}/Bin

#SSH
setenv SSH_DIR {$SSH_DIR}
setenv PATH {$PATH}:{$SSH_DIR}

#VALGRIND
setenv VALGRIND_DIR {$VALGRIND_DIR}
setenv PATH {$PATH}:{$VALGRIND_DIR}
