function plot_unit(md, data, datatype, options, canvas) { //{{{
	//PLOT_UNIT - unit plot, display data
	//
	//   Usage:
	//      plot_unit(md, data, options, canvas);
	//
	//   See also: PLOTMODEL, PLOT_MANAGER

	var name = 'unit';
	if ('unit' in canvas.nodes) {
		if (options.getfieldvalue('clf','on')=='on') {
			for (var node in canvas.nodes) {
				if (node.startsWith('unit')) {
					delete canvas.octrees[node];
					delete canvas.nodes[node];
				}
			}
		}
		else {
			name = 'unit' + Object.keys(canvas.nodes).length;
		}
	}

	//{{{ declare variables:
	//Process data and model
	var meshresults = processmesh(md, data, options);
	var x = meshresults[0]; 
	var y = meshresults[1]; 
	var z = meshresults[2]; 
	var elements = meshresults[3];
	var is2d = meshresults[4]; 
	var isplanet = meshresults[5];
	if (md.mesh.classname() !== 'mesh3dsurface') z = md.geometry.surface;
	
	//Compute coordinates and data range:
	var xlim = options.getfieldvalue('xlim', [ArrayMin(x), ArrayMax(x)]);
	var ylim = options.getfieldvalue('ylim', [ArrayMin(y), ArrayMax(y)]);
	var zlim = options.getfieldvalue('zlim', [ArrayMin(z), ArrayMax(z)]);
	
	//Handle heightscale
	var vertices, scale;
	if (md.mesh.classname() !== 'mesh3dsurface') {
		vertices = [x, y, z];
		scale = [1, 1, options.getfieldvalue('heightscale', 1)];
	}
	else {
		vertices = Node.prototype.scaleVertices(md, x, y, z, elements, options.getfieldvalue('heightscale', 1), options.getfieldvalue('maskregion',{'enabled':false}));
		scale = [1, 1, 1];
	}
	
	//Compute gl variables:
	var edgecolor = options.getfieldvalue('edgecolor', [1.0, 1.0, 1.0 ,1.0]);
	var maskzeros = options.getfieldvalue('maskzeros', {});
	var render = options.getfieldvalue('render', {});
	var cullFace = ("unit" in render) ? canvas.gl[render.unit.cullFace] : canvas.gl.BACK;
	var node = new Node(
		'canvas', canvas,
		'options', options,
		'name', name,
		'shaderName', 'TexturedDiffuse',
		'alpha', options.getfieldvalue('alpha', 1.0),
		'caxis', options.getfieldvalue('caxis',[ArrayMin(data), ArrayMax(data)]),
		'center', [(xlim[0] + xlim[1]) / 2, (ylim[0] + ylim[1]) / 2, (zlim[0] + zlim[1]) / 2],
		'cullFace', cullFace,
		'lightingBias', canvas.view.lightingBias,
		'diffuseColor', edgecolor,
		'specularStrength', 0.0,
		'enabled', options.getfieldvalue('nodata','off') == 'off' || (("unit" in render) && render.unit.enabled),
		'log', options.getfieldvalue('log',false),
		'maskEnabled', options.getfieldvalue('innermask','off') == 'on',
		'maskHeight', options.getfieldvalue('innermaskheight', 150.0) / options.getfieldvalue('heightscale', 1),
		'maskColor', options.getfieldvalue('innermaskcolor',[0.0, 0.0, 1.0, 1.0]),
		'maskObject', options.getfieldvalue('maskregion',{'enabled':false}),
		'maskZerosColor', defaultFor(maskzeros.color,[1.0, 1.0, 1.0, 1.0]),
		'maskZerosEnabled', defaultFor(maskzeros.enabled,false),
		'maskZerosTolerance', defaultFor(maskzeros.tolerance,1e-3),
		'maskZerosZeroValue', defaultFor(maskzeros.zeroValue,0.5),
		'rotation', [-90, 0, 0],
		'scale', ("unit" in render) ? [render.unit.scale, render.unit.scale, render.unit.scale] : scale
	);
	//}
	if (options.getfieldvalue('clf','on')=='on') {
		canvas.unitNode = node;
		canvas.unitData = data;
	}
	//}}}
	switch(datatype){
		//{{{ element plot
		case 1:
			//WARNING: NaN are not properly found (NaN != NaN = true)
			pos=ArrayFindNot(data, NaN); //needed for element on water
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //triangular elements
				node.patch('Faces', elements, 'Vertices', vertices, 'FaceVertexCData', data, 'FaceColor', 'flat', 'EdgeColor', edgecolor);
			}
			break;
		//}}}
		//{{{ node plot
		case 2:
			if (elements[0].length==6){ //prisms
			}
			else if (elements[0].length==4){ //tetras
			}
			else{ //triangular elements	
				node.patch('Faces', elements, 'Vertices', vertices, 'FaceVertexCData', data, 'FaceColor', 'interp', 'EdgeColor', edgecolor);
			}
			break;
		//}}}
		//{{{ quiver plot 
		case 3:
			if (is2d){
				//plot_quiver(x, y, data(:, 1), data(:, 2), options);
			}
			else{
				//plot_quiver3(x, y, z, data(:, 1), data(:, 2), data(:, 3), options);
			}
			break;
		//}}}
		default:
			throw Error(sprintf('%s%i%s\n','case ', datatype,' not supported'));
	}
} //}}}
