/*!\file Numberedcostfunction.h
 * \brief: header file for Numberedcostfunction object
 */

#ifndef _NUMBEREDCOSTFUNCTION_H_
#define _NUMBEREDCOSTFUNCTION_H_

/*Headers:*/
#include "./Definition.h"
#include "../datastructures/datastructures.h"
#include "./Elements/Element.h"
#include "./Elements/Elements.h"
#include "./FemModel.h"
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/Results.h"


IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);

class Numberedcostfunction: public Object, public Definition{

	public: 

		int   definitionenum;
		char* name;
		int   number_cost_functions;
		int*  cost_functions_list;
		
		/*Numberedcostfunction constructors, destructors :*/
		Numberedcostfunction(){/*{{{*/

			this->definitionenum = -1;
			this->name = NULL;
			this->number_cost_functions = -1;
			this->cost_functions_list = NULL;

		}
		/*}}}*/
		Numberedcostfunction(char* in_name, int in_definitionenum,int number_cost_functions_in,int* cost_functions_list_in){/*{{{*/
			_assert_(number_cost_functions_in>0); 
			_assert_(cost_functions_list_in); 

			this->definitionenum=in_definitionenum;
			this->name   = xNew<char>(strlen(in_name)+1);
			xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

			this->number_cost_functions = number_cost_functions_in;
			this->cost_functions_list = xNew<int>(number_cost_functions_in);

			for(int i=0;i<number_cost_functions_in;i++){
				this->cost_functions_list[i] = cost_functions_list_in[i];
			}
		}
		/*}}}*/
		~Numberedcostfunction(){/*{{{*/
			xDelete<int>(this->cost_functions_list);
			if(this->name)xDelete(this->name);
		}
		/*}}}*/

		/*Object virtual function resolutoin: */
		Object* copy() {/*{{{*/
			Numberedcostfunction* out = new Numberedcostfunction(this->name,this->definitionenum,this->number_cost_functions,this->cost_functions_list);
			return (Object*)out;
		}
		/*}}}*/
		void DeepEcho(void){/*{{{*/
			this->Echo();
		}
		/*}}}*/
		void Echo(void){/*{{{*/
			_printf_(" Numberedcostfunction: " << this->name << " " << this->definitionenum << "\n");
			_printf_("    number_cost_functions: "<<this->number_cost_functions<<"\n");
			_printf_("    ");
			for(int i=0;i<this->number_cost_functions;i++){
				_printf_(this->cost_functions_list[i]<< "  ");
			}
			_printf_("\n");
		}
		/*}}}*/
		int Id(void){/*{{{*/
			return -1;
		}
		/*}}}*/
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){/*{{{*/
			_error_("not implemented yet!"); 
		} 
		/*}}}*/
		int ObjectEnum(void){/*{{{*/
			return NumberedcostfunctionEnum;
		}
		/*}}}*/

		/*Definition virtual function resolutoin: */
		int DefinitionEnum(){/*{{{*/
			return this->definitionenum;
		}
		/*}}}*/
		char* Name(){/*{{{*/

			char* name2=xNew<char>(strlen(this->name)+1);
			xMemCpy(name2,this->name,strlen(this->name)+1);

			return name2;
		}
		/*}}}*/
		 IssmDouble Response(FemModel* femmodel){/*{{{*/
			
			 _assert_(number_cost_functions>0 && number_cost_functions<1e3); 
			 /*output:*/
			 IssmDouble value;

			 /*Intermediary*/
			 Results *cost_functions = NULL;

			 /*Get the value of all cost functions*/
			 femmodel->RequestedOutputsx(&cost_functions,cost_functions_list,number_cost_functions);

			 /*Get and add all contributions one by one*/
			 IssmDouble  J=0.;
			 IssmDouble* Jlist = xNew<IssmDouble>(number_cost_functions);
			 for(int i=0;i<number_cost_functions;i++){
				 ExternalResult* result=(ExternalResult*)cost_functions->GetObjectByOffset(i);
				 Jlist[i] = reCast<IssmDouble>(result->GetValue());
				 J       += Jlist[i];
			 }
			 _assert_(cost_functions->Size()==number_cost_functions);
			 
			 
			value = J;		
			_printf_("J: "<<J<<"\n");

			 /*done:*/
			delete  cost_functions;
			xDelete<IssmDouble>(Jlist);
			return value;
		 }
		 /*}}}*/
};

#endif  /* _NODALVALUE_H_ */
