/*!\file Numberedcostfunction.h
 * \brief: header file for Numberedcostfunction object
 */

#ifndef _NUMBEREDCOSTFUNCTION_H_
#define _NUMBEREDCOSTFUNCTION_H_

/*Headers:*/
#include "./Definition.h"
#include "../datastructures/datastructures.h"
#include "./Elements/Element.h"
#include "./Elements/Elements.h"
#include "./FemModel.h"
#include "./ExternalResults/ExternalResult.h"
#include "./ExternalResults/Results.h"


IssmDouble OutputDefinitionsResponsex(FemModel* femmodel,int output_enum);

class Numberedcostfunction: public Object, public Definition{

	public: 

		int   definitionenum;
		char* name;
		int   number_cost_functions;
		int*  cost_functions_list;
		
		/*Numberedcostfunction constructors, destructors :*/
		Numberedcostfunction(){/*{{{*/

			this->definitionenum = -1;
			this->name = NULL;
			this->number_cost_functions = -1;
			this->cost_functions_list = NULL;

		}
		/*}}}*/
		Numberedcostfunction(char* in_name, int in_definitionenum,int number_cost_functions_in,int* cost_functions_list_in){/*{{{*/

			_assert_(number_cost_functions_in>0); 
			_assert_(cost_functions_list_in); 

			this->definitionenum=in_definitionenum;
			this->name   = xNew<char>(strlen(in_name)+1);
			xMemCpy<char>(this->name,in_name,strlen(in_name)+1);

			this->number_cost_functions = number_cost_functions_in;
			this->cost_functions_list = xNew<int>(number_cost_functions_in);

			for(int i=0;i<number_cost_functions_in;i++){
				this->cost_functions_list[i] = cost_functions_list_in[i];
			}
		}
		/*}}}*/
		~Numberedcostfunction(){/*{{{*/
			xDelete<int>(this->cost_functions_list);
			if(this->name)xDelete(this->name);
		}
		/*}}}*/

		/*Object virtual function resolutoin: */
		Object* copy() {/*{{{*/
			Numberedcostfunction* out = new Numberedcostfunction(this->name,this->definitionenum,this->number_cost_functions,this->cost_functions_list);
			return (Object*)out;
		}
		/*}}}*/
		void DeepEcho(void){/*{{{*/
			this->Echo();
		}
		/*}}}*/
		void Echo(void){/*{{{*/
			_printf_(" Numberedcostfunction: " << this->name << " " << this->definitionenum << "\n");
			_printf_("    number_cost_functions: "<<this->number_cost_functions<<"\n");
			_printf_("    ");
			for(int i=0;i<this->number_cost_functions;i++){
				_printf_(this->cost_functions_list[i]<< "  ");
			}
			_printf_("\n");
		}
		/*}}}*/
		int Id(void){/*{{{*/
			return -1;
		}
		/*}}}*/
		void Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){/*{{{*/
			_error_("not implemented yet!"); 
		} 
		/*}}}*/
		int ObjectEnum(void){/*{{{*/
			return NumberedcostfunctionEnum;
		}
		/*}}}*/

		/*Definition virtual function resolutoin: */
		int DefinitionEnum(){/*{{{*/
			return this->definitionenum;
		}
		/*}}}*/
		char* Name(){/*{{{*/

			char* name2=xNew<char>(strlen(this->name)+1);
			xMemCpy(name2,this->name,strlen(this->name)+1);

			return name2;
		}
		/*}}}*/
		 IssmDouble Response(FemModel* femmodel){/*{{{*/
			
			 /*output:*/
			 IssmDouble value;

			 /*Intermediary*/
			 int      num_responses;
			 int     *responses      = NULL;
			 Results *cost_functions = NULL;


			 /*Recover parameters*/
			 femmodel->parameters->FindParam(&num_responses,InversionNumCostFunctionsEnum);
			 femmodel->parameters->FindParam(&responses,NULL,InversionCostFunctionsEnum);

			 /*Get the value of all cost functions*/
			 femmodel->RequestedOutputsx(&cost_functions,responses,num_responses);

			 /*Get and add all contributions one by one*/
			 IssmDouble  J=0;
			 IssmDouble* Jlist = xNew<IssmDouble>(num_responses);
			 for(int i=0;i<num_responses;i++){
				 ExternalResult* result=(ExternalResult*)cost_functions->GetObjectByOffset(i);
				 Jlist[i] = reCast<IssmDouble>(result->GetValue());
				 J       += Jlist[i];
			 }
			 _assert_(cost_functions->Size()==num_responses);
			 
			 
			value = J;		
			_printf_("J: "<<J<<"\n");
			 
			// _error_("STOP!");

			 /*done:*/
			 return value;
		 }
		 /*}}}*/
};

#endif  /* _NODALVALUE_H_ */
