
%Test Name: LovenumberstAtDepth. 
%Same as test #1 of test2084.m 

md=model();
md.cluster=generic('name',oshostname(),'np',1);

md.materials=materials('litho');
md.miscellaneous.name='FourierLoveTest';

md.verbose=verbose('111111101');
cst=365.25*24*3600*1000;

	md.materials.numlayers=6;
        md.materials.radius =  [10 1222.5 3.4800e+03   5.7010e+03   5.9510e+03   6.3010e+03   6.3710e+03]'*1e3;
	md.materials.density=  [1.0750e4 1.0750e+04   4.9780e+03   3.8710e+03   3.4380e+03   3.0370e+03]';
	md.materials.lame_mu=  [1e-5         0   2.2834e+00   1.0549e+00   7.0363e-01   5.0605e-01]'*1e11;
	md.materials.viscosity=[0             0   2.0000e+00   1.0000e+00   1.0000e+00   1.0000e+25]'*1e21;
	md.materials.lame_lambda=md.materials.lame_mu*0+5e14;
	md.materials.issolid=[1 0 1 1 1 1]';
	md.materials.isburgers=zeros(md.materials.numlayers,1);

md.love.love_kernels=1; 
md.love.allow_layer_deletion=1;
md.love.frequencies=([0]*2*pi)'/cst;
md.love.nfreq=length(md.love.frequencies);
md.love.sh_nmax=2;

md.materials.burgers_mu=md.materials.lame_mu;
md.materials.burgers_viscosity=md.materials.viscosity;

md=solve(md,'lv');

%Fields and tolerances to track changes
%loading love numbers
field_names = {'LoveH_loading_elastic','LoveK_loading_elastic','LoveL_loading_elastic','LoveKernels_degree1','LoveKernels_degree2'};
field_tolerances={1e-10,1e-10,1e-10,1e-10,1e-10}; 
field_values={...
	(md.results.LoveSolution.LoveHr(:,1)),...
	(md.results.LoveSolution.LoveKr(:,1)),...
	(md.results.LoveSolution.LoveLr(:,1)),...
	squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(2,1,:,:))),...
	squeeze(cell2mat(md.results.LoveSolution.LoveKernelsReal(3,1,:,:))),...
	};
