%Test Name: SquareSheetShelfGroundingLine2dAggressive
md=triangle(model(),'../Exp/Square.exp',150000.); %was 150000.
md=setmask(md,'../Exp/SquareShelf.exp','');
md=parameterize(md,'../Par/SquareSheetShelf.par');
md=setflowequation(md,'SSA','all');
md.initialization.vx(:)=0.;
md.initialization.vy(:)=0.;
md.geometry.base=-700.-abs(md.mesh.y-500000.)/1000.;
md.geometry.bed =-700.-abs(md.mesh.y-500000.)/1000.;
md.geometry.thickness(:)=1000.;
md.geometry.surface=md.geometry.base+md.geometry.thickness;
md.smb.mass_balance(:)=100.;
md.transient.isstressbalance=0;
md.transient.isgroundingline=1;
md.groundingline.migration='AggressiveMigration';
md.mesh.scale_factor=1.1*ones(md.mesh.numberofvertices,1);
md.transient.requested_outputs={'IceVolume','IceVolumeAboveFloatation','IceVolumeAboveFloatationScaled','GroundedArea','FloatingArea','GroundedAreaScaled','FloatingAreaScaled'};

md.cluster=generic('name',oshostname(),'np',3);
md=solve(md,'Transient');

%Fields and tolerances to track changes
field_names     ={'Bed1','Surface1','Thickness1','Floatingice1','IceVolume1','IceVolumeAboveFloatation1','IceVolumeAboveFloatationScaled1','GroundedArea1','GroundedAreaScaled1','FloatingArea1','FloatingAreaScaled1',...
	'Bed2','Surface2','Thickness2','Floatingice2','IceVolume2','IceVolumeAboveFloatation2','IceVolumeAboveFloatationScaled2','GroundedArea2','GroundedAreaScaled2','FloatingArea2','FloatingAreaScaled2',...
	'Bed3','Surface3','Thickness3','Floatingice3','IceVolume3','IceVolumeAboveFloatation3','IceVolumeAboveFloatationScaled3','GroundedArea3','GroundedAreaScaled3','FloatingArea3','FloatingAreaScaled3'};
field_tolerances={1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13,1e-13};
field_values={...
	(md.results.TransientSolution(1).Base),...
	(md.results.TransientSolution(1).Surface),...
	(md.results.TransientSolution(1).Thickness),...
	(md.results.TransientSolution(1).MaskGroundediceLevelset),...
	(md.results.TransientSolution(1).IceVolume),...
	(md.results.TransientSolution(1).IceVolumeAboveFloatation),...
	(md.results.TransientSolution(1).IceVolumeAboveFloatationScaled),...
	(md.results.TransientSolution(1).GroundedArea),...
	(md.results.TransientSolution(1).GroundedAreaScaled),...
	(md.results.TransientSolution(1).FloatingArea),...
	(md.results.TransientSolution(1).FloatingAreaScaled),...
	(md.results.TransientSolution(2).Base),...
	(md.results.TransientSolution(2).Surface),...
	(md.results.TransientSolution(2).Thickness),...
	(md.results.TransientSolution(2).MaskGroundediceLevelset),...
	(md.results.TransientSolution(2).IceVolume),...
	(md.results.TransientSolution(2).IceVolumeAboveFloatation),...
	(md.results.TransientSolution(2).IceVolumeAboveFloatationScaled),...
	(md.results.TransientSolution(2).GroundedArea),...
	(md.results.TransientSolution(2).GroundedAreaScaled),...
	(md.results.TransientSolution(2).FloatingArea),...
	(md.results.TransientSolution(2).FloatingAreaScaled),...
	(md.results.TransientSolution(3).Base),...
	(md.results.TransientSolution(3).Surface),...
	(md.results.TransientSolution(3).Thickness),...
	(md.results.TransientSolution(3).MaskGroundediceLevelset),...
	(md.results.TransientSolution(3).IceVolume),...
	(md.results.TransientSolution(3).IceVolumeAboveFloatation),...
	(md.results.TransientSolution(3).IceVolumeAboveFloatationScaled),...
	(md.results.TransientSolution(3).GroundedArea),...
	(md.results.TransientSolution(3).GroundedAreaScaled),...
	(md.results.TransientSolution(3).FloatingArea),...
	(md.results.TransientSolution(3).FloatingAreaScaled),...
	};
