/*
 * CreateElementsNodesAndMaterialsStressbalanceHoriz.c:
 */

#include "../../toolkits/toolkits.h"
#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void CreateElementsVerticesAndMaterials(Elements* elements,Vertices* vertices,Materials* materials,IoModel* iomodel,const int nummodels,int solution_type){

	/*Intermediary*/
	int i;
	int materials_type;
	bool control_analysis;
	bool dakota_analysis;
	int nnat,dummy;
	int* nature=NULL;

	/*Fetch parameters: */
	iomodel->FindConstant(&control_analysis,"md.inversion.iscontrol");
	iomodel->FindConstant(&dakota_analysis,"md.qmu.isdakota");
	iomodel->FindConstant(&materials_type,"md.materials.type");

	/*Did we already create the elements? : */
	_assert_(elements->Size()==0);

	/*Setup matpar counter in iomodel before we call on element constructors: */
	iomodel->matparcounter=iomodel->numberofelements+1;

	/*Create elements*/
	if(control_analysis)iomodel->FetchData(2,"md.inversion.min_parameters","md.inversion.max_parameters");
	switch(iomodel->meshelementtype){
		case TriaEnum:
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tria(i+1,i,i,iomodel,nummodels));
			}
			break;
		case TetraEnum:
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Tetra(i+1,i,i,iomodel,nummodels));
			}
			break;
		case PentaEnum:
			iomodel->FetchData(2,"md.mesh.upperelements","md.mesh.lowerelements");
			for(i=0;i<iomodel->numberofelements;i++){
				if(iomodel->my_elements[i]) elements->AddObject(new Penta(i+1,i,i,iomodel,nummodels));
			}
			break;
		default:
			_error_("Mesh not supported yet");
	}

	/*Create materials*/
	switch(materials_type){
		case MaticeEnum:
			iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		case MatenhancediceEnum:
			iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_E",MaterialsRheologyEEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					elements->InputDuplicate(MaterialsRheologyEEnum,MaterialsRheologyEbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		case MatdamageiceEnum:
			iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
			iomodel->FetchDataToInput(elements,"md.damage.D",DamageDEnum);
			for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					elements->InputDuplicate(DamageDEnum,DamageDbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		case MatestarEnum:
			iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_Ec",MaterialsRheologyEcEnum);
			iomodel->FetchDataToInput(elements,"md.materials.rheology_Es",MaterialsRheologyEsEnum);
			for(i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matestar(i+1,i,iomodel));
			switch(iomodel->domaindim){
				case 2:
					elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
					elements->InputDuplicate(MaterialsRheologyEcEnum,MaterialsRheologyEcbarEnum);
					elements->InputDuplicate(MaterialsRheologyEsEnum,MaterialsRheologyEsbarEnum);
					break;
				case 3:
					break;
				default:
					_error_("Mesh not supported yet");
			}
			break;
		case MaterialsEnum: 
	
			//we have several types of materials. Retrieve this info first: 
			iomodel->FetchData(&nature,&nnat,&dummy,"md.materials.nature");

			//make sure materials that are not tied to elements come last:  for now, only Matlitho qualifies.
			for(int i=0;i<nnat;i++){ 
				if (IoCodeToEnumMaterials(nature[i])==MatlithoEnum){
					int temp=nature[nnat-1];
					nature[nnat-1]=nature[i];
					nature[i]=temp;
				}
			}

			//go through list of materials, and create them: 
			for(int i=0;i<nnat;i++){ 
				switch(IoCodeToEnumMaterials(nature[i])){ //{{{
					case MaticeEnum:
						iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
						for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
						switch(iomodel->domaindim){
							case 2:
								elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
								break;
							case 3:
								break;
							default:
								_error_("Mesh not supported yet");
						}
						break;
					case MatlithoEnum:
						iomodel->FetchData(9,"md.materials.radius","md.materials.viscosity","md.materials.lame_lambda","md.materials.lame_mu","md.materials.burgers_viscosity","md.materials.burgers_mu","md.materials.isburgers","md.materials.issolid","md.materials.density");
						materials->AddObject(new Matlitho(materials->Size()+1,iomodel));
						iomodel->DeleteData(9,"md.materials.radius","md.materials.viscosity","md.materials.lame_lambda","md.materials.lame_mu","md.materials.burgers_viscosity","md.materials.burgers_mu","md.materials.isburgers","md.materials.issolid","md.materials.density");
						break;

					case MatenhancediceEnum:
						iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_E",MaterialsRheologyEEnum);
						for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
						switch(iomodel->domaindim){
							case 2:
								elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
								elements->InputDuplicate(MaterialsRheologyEEnum,MaterialsRheologyEbarEnum);
								break;
							case 3:
								break;
							default:
								_error_("Mesh not supported yet");
						}
						break;
					case MatdamageiceEnum:
						iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_n",MaterialsRheologyNEnum);
						iomodel->FetchDataToInput(elements,"md.damage.D",DamageDEnum);
						for (i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matice(i+1,i,iomodel));
						switch(iomodel->domaindim){
							case 2:
								elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
								elements->InputDuplicate(DamageDEnum,DamageDbarEnum);
								break;
							case 3:
								break;
							default:
								_error_("Mesh not supported yet");
						}
						break;
					case MatestarEnum:
						iomodel->FetchDataToInput(elements,"md.materials.rheology_B",MaterialsRheologyBEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_Ec",MaterialsRheologyEcEnum);
						iomodel->FetchDataToInput(elements,"md.materials.rheology_Es",MaterialsRheologyEsEnum);
						for(i=0;i<iomodel->numberofelements;i++) if(iomodel->my_elements[i]) materials->AddObject(new Matestar(i+1,i,iomodel));
						switch(iomodel->domaindim){
							case 2:
								elements->InputDuplicate(MaterialsRheologyBEnum,MaterialsRheologyBbarEnum);
								elements->InputDuplicate(MaterialsRheologyEcEnum,MaterialsRheologyEcbarEnum);
								elements->InputDuplicate(MaterialsRheologyEsEnum,MaterialsRheologyEsbarEnum);
								break;
							case 3:
								break;
							default:
								_error_("Mesh not supported yet");
						}
						break;

					default:
						_error_("Materials "<<EnumToStringx(IoCodeToEnumMaterials(nature[i]))<<" not supported");

				} //}}}
			}
			//Free ressources:
			xDelete<int>(nature);
			break;

		default:
			_error_("Materials "<<EnumToStringx(materials_type)<<" not supported");
	}

	/*Free data: */
	iomodel->DeleteData(7,"md.mesh.upperelements","md.mesh.lowerelements","md.material.rheology_B",
				"md.material.rheology_n","md.damage.D","md.inversion.min_parameters","md.inversion.max_parameters");

	/*Add new constant material property to materials, at the end: */
	materials->AddObject(new Matpar(iomodel));//put it at the end of the materials

	/*Create vertices: */

	/*Fetch data:*/
	iomodel->FetchData(6,"md.mesh.x","md.mesh.y","md.mesh.z","md.geometry.base","md.geometry.thickness","md.mask.ice_levelset");
	if (iomodel->domaintype == Domain3DsurfaceEnum) iomodel->FetchData(3,"md.mesh.lat","md.mesh.long","md.mesh.r");
	else iomodel->FetchDataToInput(elements,"md.mesh.scale_factor",MeshScaleFactorEnum,1.);
	
	CreateNumberNodeToElementConnectivity(iomodel,solution_type);

	for(i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]) vertices->AddObject(new Vertex(i+1,i,i,iomodel));
	}

	/*Free data: */
	iomodel->DeleteData(6,"md.mesh.x","md.mesh.y","md.mesh.z","md.geometry.base","md.geometry.thickness","md.mask.ice_levelset");
	if (iomodel->domaintype == Domain3DsurfaceEnum) iomodel->DeleteData(3,"md.mesh.lat","md.mesh.long","md.mesh.r");
}
