from fielddisplay import fielddisplay
from checkfield import checkfield
from WriteData import WriteData

class hydrologyshreve(object):
	"""
	HYDROLOGYSHREVE class definition

	   Usage:
	      hydrologyshreve=hydrologyshreve();
	"""

	def __init__(self): # {{{
		self.spcwatercolumn = float('NaN')
		self.stabilization  = 0
		self.requested_outputs = []
		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		
		string='   hydrologyshreve solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'spcwatercolumn','water thickness constraints (NaN means no constraint) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'stabilization','artificial diffusivity (default is 1). can be more than 1 to increase diffusivity.'))
		string="%s\n%s"%(string,fielddisplay(self,'requested_outputs','additional outputs requested'))
		return string
		#}}}
	def extrude(self,md): # {{{
		return self
	#}}}
	def setdefaultparameters(self): # {{{
		
		#Type of stabilization to use 0:nothing 1:artificial_diffusivity
		self.stabilization=1
		self.requested_outputs= ['default']
		return self
	#}}}
	def defaultoutputs(self,md): # {{{
		list = ['Watercolumn','HydrologyWaterVx','HydrologyWaterVy']
		return list
	#}}}

	def checkconsistency(self,md,solution,analyses):    # {{{
		
		#Early return
		if 'HydrologyShreveAnalysis' not in analyses:
			return md

		md = checkfield(md,'fieldname','hydrology.spcwatercolumn','Inf',1,'timeseries',1)
		md = checkfield(md,'fieldname','hydrology.stabilization','>=',0)
		md = checkfield(md,'fieldname','hydrology.requested_outputs','stringrow',1)
		return md
	# }}}
	def marshall(self,prefix,md,fid):    # {{{
		WriteData(fid,prefix,'name','md.hydrology.model','data',2,'format','Integer');
		WriteData(fid,prefix,'object',self,'fieldname','spcwatercolumn','format','DoubleMat','mattype',1,'timeserieslength',md.mesh.numberofvertices+1,'yts',md.constants.yts)
		WriteData(fid,prefix,'object',self,'fieldname','stabilization','format','Double')
		#process requested outputs
		outputs = self.requested_outputs
		indices = [i for i, x in enumerate(outputs) if x == 'default']
		if len(indices) > 0:
			outputscopy=outputs[0:max(0,indices[0]-1)]+self.defaultoutputs(md)+outputs[indices[0]+1:]
			outputs    =outputscopy
		WriteData(fid,prefix,'data',outputs,'name','md.hydrology.requested_outputs','format','StringArray')

	# }}}
