function displayparallel(md)
%DISPLAYPARALLEL - display parallel computation parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays all fields related to
%   parallel computation from model md, only if requested.
%
%   Usage:
%      displayparallel(md)

disp(sprintf('   parallel computation parameters:'));

disp(sprintf('\n      parallelisation:'));
fielddisplay(md,'cluster','set to ''cluster_name'' to run in cluster, ''none'' to run serially');
fielddisplay(md,'np','number of CPUS requested on cluster');
fielddisplay(md,'exclusive','set to 1 if CPUS used are not to be shared with other users, 0 otherwise');
fielddisplay(md,'time','amount of time requested on cluster');
fielddisplay(md,'alloc_cleanup','allocation cleanup before starting a job, default 1');
fielddisplay(md,'waitonlock','maximum number of minutes to wait for batch results, or return 0');
fielddisplay(md,'queue','special queue name on cluster? default is '''' ');

disp(sprintf('\n      ice solver options:'));
fielddisplay(md,'solver_type','solver type for Ice: ''general'', ''lu'' or ''cholesky''');
disp(sprintf('\n      cielo solver options:'));
fielddisplay(md,'solverstring','solver string for Petsc. See solversetto... routines. Default is mumps');
