function flag=waitonlock(filename,timelimit)
%WAITONLOCK - wait for a file
%
%   This routine will return when a file named 'filename' is written to disk.
%   If the time limit given in input is exceeded, return 0
%
%   Usage:
%      flag=waitonlock(filename,timelimit)

%initialize time and file presence test flag
time=0;
ispresent=0;
disp(['waiting for ' filename ' hold on... (Ctrl+C to exit)'])

%loop till file .lock exist or time is up
while (ispresent==0 & time<timelimit)
	ispresent=exist(filename,'file');
	pause(1);
	time=time+1/60;
end

%build output
if (time>timelimit),
	flag=0;
else
	flag=1;
end
