function md=modeldefault(varargin),
%MODELDEFAULT - build a model with default parameters
%
%   This routine is used to create and parameterize a model.
%   Several options are available, but only the domain outline
%   is mandatory.
%   Default options will be applied when not specified.
%
%   Available options:
%      o 'domainoutline' followed by the name of an ARGUS file
%        describing the domain to be meshed
%      o 'resolution': mesh resolution
%      o 'iceshelves': ice shelves contours in an ARGUS file
%      o 'islands': islands contours in an ARGUS file
%      o 'thicknesspath': path to the thickness data file
%      o 'firnpath': path to the thickness data file
%      o 'surfacepath': path to the thickness data file
%      o 'velocitypath': path to the thickness data file
%      o 'temperaturepath': path to the thickness data file
%      o 'heatfluxpath': path to the thickness data file
%      o 'numlayers': number of layers in the mesh vertical extrusion
%      o 'extrusionexponent': exponent used in the vertical extrusion
%      o 'elementstype': type of elements for diagnostic runs
%
%   Usage:
%      md=modeldefault(varargin)
%
%   Examples:
%      md=modeldefault('domainoutline','Pig.exp');

%some checks
if nargout~=1
	help modeldefault
	error('modeldefault error message: bad usage')
end

%recover options
disp(sprintf('\nRecovering options...\n'));
options=optionlist2cell(varargin{:});

%process options
options=modeldefault_process(options);

%initialize output:
md=model;

%Mesh the model
disp(sprintf('\nMesh generation...'));
md=mesh(md,options.domainoutline,options.resolution);

%geography
disp(sprintf('Geography...'));
md=geography(md,options.iceshelves,options.islands);

%parameterization
disp(sprintf('Model parameterization...'));
defaultparams;

%extrusion
disp(sprintf('Mesh extrusion...'));
md=extrude(md,options.numlayers,options.extrusionexponent);

%elements type
disp(sprintf('Setting elemtens type...'));
md=setelementstype(md,options.elementstype,'all');
disp(sprintf('done'));
