function displaythermal(md)
%DISPLAYTHERMAL - display solution parameters applied to thermal model
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays the solution parameters
%   from model md, only if requested.
%
%   Usage:
%      displaythermal(md)

disp(sprintf('   Thermal solution parameters:'));

disp(sprintf('\n      parameters:'));
fielddisplay(md,'stabilize_constraints','stabilize unstable thermal constraints that keep zigzagging (default is 0)');
fielddisplay(md,'min_thermal_constraints','threshold to declare convergence of thermal solution (default is 0)');

disp(sprintf('\n      boundary conditions:'));
fielddisplay(md,'spctemperature','constraints flag list (first column) and values (second column)');
fielddisplay(md,'melting','melting rate [m/a]');

disp(sprintf('\n      transient:'));
fielddisplay(md,'dt','time step [yr]');
fielddisplay(md,'ndt','time span [yr]');
