/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"
#include "./Matpar.h"

class Element;
class Pengrid: public Load{

	private: 

		int		id;
		int     dof;
		int     active;
		double  penalty_offset; 
		int     thermal_steadystate;
		
		/*nodes: */
		int     node_id;
		Node*   node;
		int     node_offset;

		int mparid;
		Matpar* matpar; 
		int   matpar_offset;

		int stabilize_constraints;
		int zigzag_counter;

	public:

		Pengrid();
		Pengrid(int	id, int node_id,int mparid,int dof, int active, double penalty_offset,int thermal_steadystate,int stabilize_constraints);
		~Pengrid();

		void  Echo();
		void  DeepEcho();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type,int sub_analysis_type);
		void  Configure(void* elements,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,void* inputs,int analysis_type,int sub_analysis_type);
		void  CreatePVector(Vec pg, void* inputs, int analysis_type,int sub_analysis_type);
		void  UpdateFromInputs(void* inputs);
		void  PenaltyCreateKMatrix(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVector(Vec pg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixDiagnosticStokes(Mat Kgg,void* inputs,double kmax,int analysis_type,int sub_analysis_type);
		void  GetDofList(int* doflist,int* pnumberofdofspernode);
		Object* copy();
		void  PenaltyCreateKMatrixThermal(Mat Kgg,void* vinputs,double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreateKMatrixMelting(Mat Kgg,void* vinputs,double kmax,int analysis_type,int sub_analysis_type);
		void  MatparConfiguration(Matpar* matpar,int matpar_offset);
		void  PenaltyCreatePVectorThermal(Vec pg, void* inputs, double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyCreatePVectorMelting(Vec pg, void* inputs, double kmax,int analysis_type,int sub_analysis_type);
		void  PenaltyConstrain(int* punstable,void* inputs,int analysis_type,int sub_analysis_type);
		void  PenaltyConstrainThermal(int* punstable,void* inputs,int analysis_type,int sub_analysis_type);
};

#endif  /* _PENGRID_H_ */


