/*
 * \file EnumDefinitions.h:
 * \brief: enum functions for our objects
 */

#ifndef _ENUM_DEFINITIONS_
#define _ENUM_DEFINITIONS_

enum definitions{
	FemModelEnum,
	ParametersSTARTEnum,
	/*Parameters {{{*/
	AdolcParamEnum,
	FSSolverEnum,
	FemModelCommEnum,
	WorldCommEnum,
	IcecapToEarthCommEnum,
	NumModelsEnum,
	ModelIdEnum,
	EarthIdEnum,
	SolutionTypeEnum,
	AnalysisTypeEnum,
	AnalysisCounterEnum,
	ConfigurationTypeEnum,
	InputToExtrudeEnum,
	InputToL2ProjectEnum,
	InputToDepthaverageInEnum,
	InputToDepthaverageOutEnum,
	InputToSmoothEnum,
	SmoothThicknessMultiplierEnum,
	LevelsetStabilizationEnum,
	/*}}}*/
	/*Model fields {{{*/
	AutodiffIsautodiffEnum, 
	AutodiffNumDependentsEnum,
	AutodiffDependentObjectsEnum,
	AutodiffNumIndependentsEnum,
	AutodiffJacobianEnum,
	AutodiffXpEnum,
	AutodiffDriverEnum,
	AutodiffFosForwardIndexEnum,
	AutodiffFovForwardIndicesEnum,
	AutodiffFosReverseIndexEnum,
	AutodiffKeepEnum,
	AutodiffObufsizeEnum,
	AutodiffLbufsizeEnum,
	AutodiffCbufsizeEnum,
	AutodiffTbufsizeEnum,
	AutodiffGcTriggerRatioEnum,
	AutodiffGcTriggerMaxSizeEnum,
	BalancethicknessStabilizationEnum,
	BalancethicknessThickeningRateEnum,
	BasalforcingsEnum,
	BasalforcingsGeothermalfluxEnum,
	BasalforcingsGroundediceMeltingRateEnum,
	BasalforcingsFloatingiceMeltingRateEnum,
	BasalforcingsDeepwaterMeltingRateEnum,
	BasalforcingsDeepwaterElevationEnum,
	BasalforcingsUpperwaterElevationEnum,
	BasalforcingsMeltrateFactorEnum,
	BasalforcingsThresholdThicknessEnum,
	BasalforcingsUpperdepthMeltEnum,
	BasalforcingsMantleconductivityEnum,
	BasalforcingsNusseltEnum,
	BasalforcingsDtbgEnum,
	BasalforcingsPlumeradiusEnum,
	BasalforcingsTopplumedepthEnum,
	BasalforcingsBottomplumedepthEnum,
	BasalforcingsPlumexEnum,
	BasalforcingsPlumeyEnum,
	BasalforcingsCrustthicknessEnum,
	BasalforcingsUppercrustthicknessEnum,
	BasalforcingsUppercrustheatEnum,
	BasalforcingsLowercrustheatEnum,
	FloatingMeltRateEnum,
	LinearFloatingMeltRateEnum,
	MismipFloatingMeltRateEnum,
	MantlePlumeGeothermalFluxEnum,
	BedEnum,
	BaseEnum,
	ConstantsGEnum,
	ConstantsReferencetemperatureEnum,
	ConstantsYtsEnum,
	DependentObjectEnum,
	StressbalanceAbstolEnum,
	StressbalanceConvergenceNumStepsEnum,
	StressbalanceIsnewtonEnum,
	StressbalanceMaxiterEnum,
	StressbalancePenaltyFactorEnum,
	StressbalanceReltolEnum,
	StressbalanceNumRequestedOutputsEnum,
	StressbalanceRequestedOutputsEnum,
	StressbalanceRestolEnum,
	StressbalanceRiftPenaltyThresholdEnum,
	StressbalanceShelfDampeningEnum,
	StressbalanceFSreconditioningEnum,
	StressbalanceViscosityOvershootEnum,
	LoadingforceXEnum,
	LoadingforceYEnum,
	LoadingforceZEnum,
	FlowequationIsSIAEnum,
	FlowequationIsSSAEnum,
	FlowequationIsL1L2Enum,
	FlowequationIsHOEnum,
	FlowequationIsFSEnum,
	FlowequationFeFSEnum,
	FlowequationBorderFSEnum,
	FrictionAsEnum,
	FrictionCoefficientEnum,
	FrictionCoefficientcoulombEnum,
	FrictionPressureAdjustedTemperatureEnum,
	FrictionPEnum,
	FrictionQEnum,
	FrictionMEnum,
	FrictionCEnum,
	FrictionLawEnum,
	FrictionGammaEnum,
	FrictionFEnum,
	FrictionWaterLayerEnum,
	FrictionEffectivePressureEnum,
	FrictionCouplingEnum,
	GeometryHydrostaticRatioEnum,
	HydrologyModelEnum,
	HydrologyshreveEnum,
	HydrologyshreveStabilizationEnum,
	HydrologydcEnum,
	SedimentHeadEnum,
	SedimentHeadOldEnum,
	SedimentHeadResidualEnum,
	EffectivePressureEnum,
	EplHeadEnum,
	EplHeadOldEnum,
	EplHeadSlopeXEnum,
	EplHeadSlopeYEnum,
	EplZigZagCounterEnum,
	HydrologydcMaxIterEnum,
	HydrologydcRelTolEnum,
	HydrologydcSedimentCompressibilityEnum,
	HydrologydcSedimentPorosityEnum,
	HydrologydcSedimentThicknessEnum,
	HydrologydcSedimentTransmitivityEnum,
	HydrologydcWaterCompressibilityEnum,
	HydrologydcMaskEplactiveNodeEnum,
	HydrologydcMaskEplactiveEltEnum,
	HydrologydcEplCompressibilityEnum,
	HydrologydcEplPorosityEnum,
	HydrologydcEplInitialThicknessEnum,
	HydrologydcEplColapseThicknessEnum,
	HydrologydcEplMaxThicknessEnum,
	HydrologydcEplThicknessEnum,
	HydrologydcEplThicknessOldEnum,
	HydrologydcEplThickCompEnum,
	HydrologydcEplConductivityEnum,
	HydrologydcIsefficientlayerEnum,
	HydrologydcSedimentlimitFlagEnum,
	HydrologydcSedimentlimitEnum,
	HydrologydcTransferFlagEnum,
	HydrologydcLeakageFactorEnum,
	HydrologydcPenaltyFactorEnum,
	HydrologydcPenaltyLockEnum,
	HydrologydcEplflipLockEnum,
	HydrologydcBasalMoulinInputEnum,
	HydrologyLayerEnum,
	HydrologySedimentEnum,
	HydrologyEfficientEnum,
	HydrologySedimentKmaxEnum,
	HydrologysommersEnum,
	HydrologyHeadEnum,
	HydrologyHeadOldEnum,
	HydrologyGapHeightEnum,
	HydrologyBumpSpacingEnum,
	HydrologyBumpHeightEnum,
	HydrologyEnglacialInputEnum,
	HydrologyMoulinInputEnum,
	HydrologyReynoldsEnum,
	HydrologyNeumannfluxEnum,
   HydrologyRelaxationEnum,
	HydrologyBasalFluxEnum,
	HydrologyStorageEnum,
	InversionControlParametersEnum,
	InversionControlScalingFactorsEnum,
	InversionCostFunctionThresholdEnum,
	InversionCostFunctionsCoefficientsEnum,
	InversionCostFunctionsEnum,
	InversionGradientScalingEnum,
	InversionIscontrolEnum,
	InversionTypeEnum,
	InversionIncompleteAdjointEnum,
	InversionMaxiterPerStepEnum,
	InversionMaxiterEnum,
	InversionMaxstepsEnum,
	InversionFatolEnum,
	InversionFrtolEnum,
	InversionGatolEnum,
	InversionGrtolEnum,
	InversionGttolEnum,
	InversionAlgorithmEnum,
	InversionNstepsEnum,
	InversionDxminEnum,
	InversionNumControlParametersEnum,
	InversionNumCostFunctionsEnum,
	InversionStepThresholdEnum,
	InversionThicknessObsEnum,
	InversionSurfaceObsEnum,
	InversionVxObsEnum,
	InversionVyObsEnum,
	InversionVzObsEnum,
	MaskIceLevelsetEnum,
	MaskOceanLevelsetEnum,
	MaskLandLevelsetEnum,
	MaterialsBetaEnum,
	MaterialsHeatcapacityEnum,
	MaterialsLatentheatEnum,
	MaterialsMeltingpointEnum,
	MaterialsMixedLayerCapacityEnum,
	MaterialsRheologyBEnum,
	MaterialsRheologyBbarEnum,
	MaterialsRheologyLawEnum,
	MaterialsRheologyNEnum,
	MaterialsRheologyEEnum,
	MaterialsRheologyEbarEnum,
	MaterialsRheologyEcEnum,
	MaterialsRheologyEcbarEnum,
	MaterialsRheologyEsEnum,
	MaterialsRheologyEsbarEnum,
	DamageDEnum,
	DamageFEnum,
	DamageDbarEnum,
	DamageLawEnum,
	DamageC1Enum,
	DamageC2Enum,
	DamageC3Enum,
	DamageC4Enum,
	DamageElementinterpEnum,
	DamageHealingEnum,
	DamageStressThresholdEnum,
	DamageKappaEnum,
	DamageStabilizationEnum,
	DamageMaxiterEnum,
	DamageMaxDamageEnum,
	DamageEquivStressEnum,
	DamageEvolutionNumRequestedOutputsEnum,
	DamageEvolutionRequestedOutputsEnum,
	DamageEnum,
	NewDamageEnum,
	StressIntensityFactorEnum,
	CalvingLawEnum,
	CalvingCalvingrateEnum,
	CalvingMeltingrateEnum,
	CalvingLevermannEnum,
	CalvingDevEnum,
	CalvingMinthicknessEnum,
	DefaultCalvingEnum,
	CalvinglevermannCoeffEnum,
	CalvinglevermannMeltingrateEnum,
	CalvingdevCoeffEnum,
	CalvingratexEnum,
	CalvingrateyEnum,
	CalvingratexAverageEnum,
	CalvingrateyAverageEnum,
	CalvingStressThresholdGroundediceEnum,
	CalvingStressThresholdFloatingiceEnum,
	CalvingMaxEnum,
	StrainRateparallelEnum,
	StrainRateperpendicularEnum,
	StrainRateeffectiveEnum,
	MaterialsRhoIceEnum,
	MaterialsRhoSeawaterEnum,
	MaterialsRhoFreshwaterEnum,
	MaterialsMuWaterEnum,
	MaterialsThermalExchangeVelocityEnum,
	MaterialsThermalconductivityEnum,
	MaterialsTemperateiceconductivityEnum,
	MaterialsLithosphereShearModulusEnum,
	MaterialsLithosphereDensityEnum,
	MaterialsMantleShearModulusEnum,
	MaterialsMantleDensityEnum,
	MaterialsEarthDensityEnum,
	MeshAverageVertexConnectivityEnum,
	MeshXEnum,
	MeshYEnum,
	MeshZEnum,
	MeshElementsEnum,
	MeshNumberofelementsEnum,
	MeshNumberoflayersEnum,
	MeshNumberofverticesEnum,
	MeshVertexonbaseEnum,
	MeshVertexonsurfaceEnum,
	MeshVertexonboundaryEnum,
	MeshElementtypeEnum,
	DomainTypeEnum,
	DomainDimensionEnum,
	Domain2DhorizontalEnum,
	Domain2DverticalEnum,
	Domain3DEnum,
	Domain3DsurfaceEnum,
	MasstransportHydrostaticAdjustmentEnum,
	MasstransportIsfreesurfaceEnum,
	MasstransportMinThicknessEnum,
	MasstransportPenaltyFactorEnum,
	MasstransportSpcthicknessEnum,
	MasstransportStabilizationEnum,
	MasstransportNumRequestedOutputsEnum,
	MasstransportRequestedOutputsEnum,
	QmuIsdakotaEnum,
	MassFluxSegmentsEnum,
	MassFluxSegmentsPresentEnum,
	QmuNumberofpartitionsEnum,
	QmuNumberofresponsesEnum,
	QmuPartitionEnum,
	QmuResponsedescriptorsEnum,
	QmuVariabledescriptorsEnum,
	SettingsResultsOnNodesEnum,
	SettingsIoGatherEnum,
	SettingsLowmemEnum,
	SettingsOutputFrequencyEnum,
	SettingsRecordingFrequencyEnum,
	SettingsWaitonlockEnum,
	SettingsSolverResidueThresholdEnum,
	DebugProfilingEnum,
	ProfilingCurrentMemEnum,
	ProfilingCurrentFlopsEnum,
	ProfilingSolutionTimeEnum,
	SteadystateMaxiterEnum,
	SteadystateNumRequestedOutputsEnum,
	SteadystateReltolEnum,
	SteadystateRequestedOutputsEnum,
	SurfaceEnum,
	ThermalIsenthalpyEnum,
	ThermalIsdynamicbasalspcEnum,
	ThermalReltolEnum,
	ThermalMaxiterEnum,
	ThermalPenaltyFactorEnum,
	ThermalPenaltyLockEnum,
	ThermalPenaltyThresholdEnum,
	ThermalSpctemperatureEnum,
	ThermalStabilizationEnum,
	ThermalNumRequestedOutputsEnum,
	ThermalRequestedOutputsEnum,
	GiaMantleViscosityEnum,
	GiaLithosphereThicknessEnum,
	ThicknessEnum,
	TimesteppingStartTimeEnum,
	TimesteppingFinalTimeEnum,
	TimesteppingCflCoefficientEnum,
	TimesteppingTimeAdaptEnum,
	TimesteppingTimeStepEnum,
	TimesteppingInterpForcingsEnum,
	TransientIssmbEnum,
	TransientIscouplerEnum,
	TransientIsstressbalanceEnum,
	TransientIsgroundinglineEnum,
	TransientIsmasstransportEnum,
	TransientIsthermalEnum,
	TransientIsgiaEnum,
	TransientIsesaEnum,
	TransientIsdamageevolutionEnum,
	TransientIshydrologyEnum,
	TransientIsmovingfrontEnum,
	TransientIsslrEnum,
	TransientNumRequestedOutputsEnum,
	TransientRequestedOutputsEnum,
	BalancethicknessApparentMassbalanceEnum,
	BalancethicknessDiffusionCoefficientEnum,
	BalancethicknessOmegaEnum,
	BalancethicknessD0Enum,
	/*}}}*/
	/*Smb{{{*/
	SmbEnum,
	SmbAnalysisEnum,
	SmbSolutionEnum,
	SmbNumRequestedOutputsEnum,
	SmbRequestedOutputsEnum,
	SmbIsInitializedEnum,
	SmbDziniEnum,
	SmbDiniEnum,
	SmbReiniEnum,
	SmbGdniniEnum,
	SmbGspiniEnum,
	SmbECiniEnum,
	SmbWiniEnum,
	SmbAiniEnum,
	SmbTiniEnum,
	SmbSizeiniEnum,
	/*SMBforcing*/
	SMBforcingEnum,
	SmbMassBalanceEnum,
	/*SMBgemb*/
	SMBgembEnum,
	SmbInitDensityScalingEnum,
	SmbTaEnum,
	SmbVEnum,
	SmbDswrfEnum,
	SmbDlwrfEnum,
	SmbPEnum, 
	SmbEAirEnum, 
	SmbPAirEnum,
	SmbTmeanEnum,
	SmbCEnum,
	SmbTzEnum,
	SmbVzEnum, 
	SmbDtEnum,
	SmbDzEnum,
	SmbAIdxEnum,
	SmbSwIdxEnum,
	SmbDenIdxEnum,
	SmbZTopEnum, 
	SmbDzTopEnum, 
	SmbDzMinEnum, 
	SmbZYEnum, 
	SmbZMaxEnum, 
	SmbZMinEnum, 
	SmbOutputFreqEnum, 
	SmbASnowEnum, 
	SmbAIceEnum, 
	SmbCldFracEnum, 
	SmbT0wetEnum, 
	SmbT0dryEnum, 
	SmbKEnum, 
	SmbDEnum,
	SmbReEnum,
	SmbGdnEnum,
	SmbGspEnum,
	SmbECEnum,
	SmbWEnum,
	SmbAEnum,
	SmbTEnum,
	SmbIsgraingrowthEnum,
	SmbIsalbedoEnum,
	SmbIsshortwaveEnum,
	SmbIsthermalEnum,
	SmbIsaccumulationEnum,
	SmbIsmeltEnum,
	SmbIsdensificationEnum,
	SmbIsturbulentfluxEnum,
	SmbDz_addEnum,
	SmbM_addEnum,
	/*SMBpdd*/
	SMBpddEnum,	
	SmbDelta18oEnum,
	SmbDelta18oSurfaceEnum,
	SmbIsdelta18oEnum,
	SmbIsmungsmEnum,
	SmbIsd18opdEnum,
	SmbPrecipitationsPresentdayEnum,
	SmbPrecipitationsLgmEnum,
	SmbTemperaturesPresentdayEnum,
	SmbTemperaturesLgmEnum,
	SmbPrecipitationEnum,
	SmbDesfacEnum,
	SmbS0pEnum,
	SmbS0tEnum,
	SmbRlapsEnum,
	SmbRlapslgmEnum,
	SmbPfacEnum,
	SmbTdiffEnum,
	SmbSealevEnum,
	SMBd18opddEnum,
	SmbDpermilEnum,
	SmbFEnum,
	SMBgradientsEnum,
	SmbMonthlytemperaturesEnum,
	SmbHrefEnum,
	SmbSmbrefEnum,
	SmbBPosEnum,
	SmbBNegEnum,
	SMBhenningEnum,
	SMBcomponentsEnum,
	SmbAccumulationEnum,
	SmbEvaporationEnum,
	SmbRunoffEnum,
	SMBmeltcomponentsEnum,
	SmbMeltEnum,
	SmbRefreezeEnum,
	SMBgcmEnum,
	/*SMBgradientsela*/
	SMBgradientselaEnum,
	SmbElaEnum,
	SmbBMaxEnum,
	SmbBMinEnum,
	/*}}}*/
	/*Inputs {{{*/
	AdjointpEnum,
	AdjointxEnum,
	AdjointyEnum,
	AdjointzEnum,
	BalancethicknessMisfitEnum,
	BedSlopeXEnum,
	BedSlopeYEnum,
	BoundaryEnum,
	ConvergedEnum,
	InternalEnum,
	MassFluxEnum,
	MeltingOffsetEnum,
	MisfitEnum,
	PressureEnum,
	PressurePicardEnum,
	AndroidFrictionCoefficientEnum,
	ResetPenaltiesEnum,
	SurfaceAbsVelMisfitEnum,
	SurfaceAreaEnum,
	SurfaceAverageVelMisfitEnum,
	SurfaceLogVelMisfitEnum,
	SurfaceLogVxVyMisfitEnum,
	SurfaceRelVelMisfitEnum,
	SurfaceSlopeXEnum,
	SurfaceSlopeYEnum,
	TemperatureEnum,
	TemperaturePicardEnum,
	TemperaturePDDEnum,
	ThicknessAbsMisfitEnum,
	SurfaceAbsMisfitEnum,
	VelEnum,
	VelocityEnum,
	VxAverageEnum,
	VxEnum,
	VxPicardEnum,
	VyAverageEnum,
	VyEnum,
	VyPicardEnum,
	VzEnum,
	VzSSAEnum,
	VzHOEnum,
	VzPicardEnum,
	VzFSEnum,
	VxMeshEnum,
	VyMeshEnum,
	VzMeshEnum,
	EnthalpyEnum,
	EnthalpyPicardEnum,
	ThicknessAbsGradientEnum,
	ThicknessAlongGradientEnum,
	ThicknessAcrossGradientEnum,
	ThicknessPositiveEnum,
	IntMatParamEnum,
	RheologyBbarAbsGradientEnum,
	RheologyBAbsGradientEnum,
	DragCoefficientAbsGradientEnum,
	TransientInputEnum,
	WaterfractionEnum,
	WaterfractionDrainageEnum,
	WaterfractionDrainageIntegratedEnum,
	WatercolumnEnum,
	ViscousHeatingEnum,
	HydrologyWaterVxEnum,
	HydrologyWaterVyEnum,
	DrivingStressXEnum,
	DrivingStressYEnum,
	SigmaNNEnum,
	StressTensorEnum,
	StressTensorxxEnum,
	StressTensorxyEnum,
	StressTensorxzEnum,
	StressTensoryyEnum,
	StressTensoryzEnum,
	StressTensorzzEnum,
	StressMaxPrincipalEnum,
	DeviatoricStressEnum,
	DeviatoricStressxxEnum,
	DeviatoricStressxyEnum,
	DeviatoricStressxzEnum,
	DeviatoricStressyyEnum,
	DeviatoricStressyzEnum,
	DeviatoricStresszzEnum,
	DeviatoricStresseffectiveEnum,
	LambdaSEnum,
	StrainRateEnum,
	StrainRatexxEnum,
	StrainRatexyEnum,
	StrainRatexzEnum,
	StrainRateyyEnum,
	StrainRateyzEnum,
	StrainRatezzEnum,
	DivergenceEnum,
	MaxDivergenceEnum,
	GiaCrossSectionShapeEnum,
	GiadWdtEnum,
	GiaWEnum, 
	/*}}}*/
	/*Results{{{*/
	SaveResultsEnum,
	BoolExternalResultEnum,
	DoubleExternalResultEnum,
	DoubleMatExternalResultEnum,
	IntExternalResultEnum,
	IntMatExternalResultEnum,
	JEnum,
	StringExternalResultEnum,
	StepEnum,
	TimeEnum,
	WaterColumnOldEnum,
	/*}}}*/
	/*Output Definitions{{{*/
	SurfaceObservationEnum,
	WeightsSurfaceObservationEnum,
	OutputdefinitionEnum,
	Outputdefinition1Enum,
	Outputdefinition2Enum,
	Outputdefinition3Enum,
	Outputdefinition4Enum,
	Outputdefinition5Enum,
	Outputdefinition6Enum,
	Outputdefinition7Enum,
	Outputdefinition8Enum,
	Outputdefinition9Enum,
	Outputdefinition10Enum,
	Outputdefinition11Enum,
	Outputdefinition12Enum,
	Outputdefinition13Enum,
	Outputdefinition14Enum,
	Outputdefinition15Enum,
	Outputdefinition16Enum,
	Outputdefinition17Enum,
	Outputdefinition18Enum,
	Outputdefinition19Enum,
	Outputdefinition20Enum,
	Outputdefinition21Enum,
	Outputdefinition22Enum,
	Outputdefinition23Enum,
	Outputdefinition24Enum,
	Outputdefinition25Enum,
	Outputdefinition26Enum,
	Outputdefinition27Enum,
	Outputdefinition28Enum,
	Outputdefinition29Enum,
	Outputdefinition30Enum,
	Outputdefinition31Enum,
	Outputdefinition32Enum,
	Outputdefinition33Enum,
	Outputdefinition34Enum,
	Outputdefinition35Enum,
	Outputdefinition36Enum,
	Outputdefinition37Enum,
	Outputdefinition38Enum,
	Outputdefinition39Enum,
	Outputdefinition40Enum,
	Outputdefinition41Enum,
	Outputdefinition42Enum,
	Outputdefinition43Enum,
	Outputdefinition44Enum,
	Outputdefinition45Enum,
	Outputdefinition46Enum,
	Outputdefinition47Enum,
	Outputdefinition48Enum,
	Outputdefinition49Enum,
	Outputdefinition50Enum,
	Outputdefinition51Enum,
	Outputdefinition52Enum,
	Outputdefinition53Enum,
	Outputdefinition54Enum,
	Outputdefinition55Enum,
	Outputdefinition56Enum,
	Outputdefinition57Enum,
	Outputdefinition58Enum,
	Outputdefinition59Enum,
	Outputdefinition60Enum,
	Outputdefinition61Enum,
	Outputdefinition62Enum,
	Outputdefinition63Enum,
	Outputdefinition64Enum,
	Outputdefinition65Enum,
	Outputdefinition66Enum,
	Outputdefinition67Enum,
	Outputdefinition68Enum,
	Outputdefinition69Enum,
	Outputdefinition70Enum,
	Outputdefinition71Enum,
	Outputdefinition72Enum,
	Outputdefinition73Enum,
	Outputdefinition74Enum,
	Outputdefinition75Enum,
	Outputdefinition76Enum,
	Outputdefinition77Enum,
	Outputdefinition78Enum,
	Outputdefinition79Enum,
	Outputdefinition80Enum,
	Outputdefinition81Enum,
	Outputdefinition82Enum,
	Outputdefinition83Enum,
	Outputdefinition84Enum,
	Outputdefinition85Enum,
	Outputdefinition86Enum,
	Outputdefinition87Enum,
	Outputdefinition88Enum,
	Outputdefinition89Enum,
	Outputdefinition90Enum,
	Outputdefinition91Enum,
	Outputdefinition92Enum,
	Outputdefinition93Enum,
	Outputdefinition94Enum,
	Outputdefinition95Enum,
	Outputdefinition96Enum,
	Outputdefinition97Enum,
	Outputdefinition98Enum,
	Outputdefinition99Enum,
	Outputdefinition100Enum,   
	OutputdefinitionListEnum,
	MassfluxatgateEnum,
	NodalvalueEnum,
	VxObsEnum,
	VyObsEnum,
	/*}}}*/
	/*Relaxation{{{*/
	AbsoluteEnum,
	IncrementalEnum,
	AugmentedLagrangianREnum,
	AugmentedLagrangianRhopEnum,
	AugmentedLagrangianRlambdaEnum,
	AugmentedLagrangianRholambdaEnum,
	AugmentedLagrangianThetaEnum,
	/*}}}*/
	/*Grounding Line{{{*/
	NoneEnum,
	AggressiveMigrationEnum,
	SoftMigrationEnum,
	SubelementMigrationEnum,
	SubelementMigration2Enum,
	ContactEnum,
	GroundingOnlyEnum,
	MaskGroundediceLevelsetEnum,
	/*}}}*/
	/*Parameters{{{*/
	AdjointEnum,
	ColinearEnum,
	ControlSteadyEnum,
	FsetEnum,
	Gradient1Enum,
	Gradient2Enum,
	Gradient3Enum,
	GradientEnum,
	GroundinglineMigrationEnum,
	GsetEnum,
	IndexEnum,
	IndexedEnum,
	IntersectEnum,
	NodalEnum,
	OldGradientEnum,
	OutputBufferPointerEnum,
	OutputBufferSizePointerEnum,
	OutputFilePointerEnum,
	ToolkitsFileNameEnum,
	RootPathEnum,
	OutputFileNameEnum,
	InputFileNameEnum,
	LockFileNameEnum,
	RestartFileNameEnum,
	ToolkitsOptionsAnalysesEnum,
	ToolkitsOptionsStringsEnum,
	QmuErrNameEnum,
	QmuInNameEnum,
	QmuOutNameEnum,
	RegularEnum,
	ScaledEnum,
	SeparateEnum,
	SsetEnum,
	/*}}}*/
	/*Toolkits{{{*/
	DenseEnum,
	MpiDenseEnum,
	MpiSparseEnum,
	SeqEnum,
	MpiEnum,
	MumpsEnum,
	GslEnum,
	/*}}}*/
	/*Rheology law (move to Material) {{{*/
	CuffeyEnum,
	BuddJackaEnum,
	CuffeyTemperateEnum,
	PatersonEnum,
	ArrheniusEnum,
	LliboutryDuvalEnum,
	/*}}}*/
	/*Levelset related enums (will be moved to appropriate place when finished){{{*/
	ExtrapolationVariableEnum,
	IceMaskNodeActivationEnum,
	LevelsetfunctionSlopeXEnum,
	LevelsetfunctionSlopeYEnum,
	LevelsetfunctionPicardEnum,
	LevelsetReinitFrequencyEnum,
	/*}}}*/
	/*Sea Level Rise{{{*/
	SealevelEnum,
	SealevelUmotionEnum,
	SealevelNmotionEnum,
	SealevelEmotionEnum,
	SealevelAbsoluteEnum,
	SealevelEustaticEnum,
	SealevelObsEnum,
	SealevelWeightsEnum,
	SealevelriseDeltathicknessEnum,
	SealevelriseCumDeltathicknessEnum,
	SealevelriseSpcthicknessEnum,
	SealevelriseMaxiterEnum,
	SealevelriseLoopIncrementEnum,
	SealevelriseReltolEnum,
	SealevelriseAbstolEnum,
	SealevelriseRigidEnum,
	SealevelriseElasticEnum,
	SealevelriseOceanAreaScalingEnum,
	SealevelriseStericRateEnum,
	SealevelriseRunFrequencyEnum,
	SealevelriseRunCountEnum,
	SealevelriseRotationEnum,
	SealevelriseTidalLoveHEnum,
	SealevelriseTidalLoveKEnum, 
	SealevelriseFluidLoveEnum, 
	SealevelriseEquatorialMoiEnum, 
	SealevelrisePolarMoiEnum, 
	SealevelriseAngularVelocityEnum,
	SealevelriseGElasticEnum,
	SealevelriseUElasticEnum,
	SealevelriseHElasticEnum,
	SealevelriseTransitionsEnum,
	SealevelriseRequestedOutputsEnum,
	SealevelriseNumRequestedOutputsEnum,
	/*}}}*/
	/*Elastic adjustment (ESA){{{*/
	EsaUmotionEnum,
	EsaNmotionEnum,
	EsaEmotionEnum,
	EsaStrainratexxEnum,
   EsaStrainratexyEnum,
   EsaStrainrateyyEnum,
   EsaRotationrateEnum,
	EsaDeltathicknessEnum,
	EsaUElasticEnum,
	EsaHElasticEnum,
	EsaTransitionsEnum,
	EsaRequestedOutputsEnum,
	EsaNumRequestedOutputsEnum,
	/*}}}*/
	/*Adaptive mesh refinement (AMR){{{*/
	AmrLevelMaxEnum,
	AmrRegionLevel1Enum,
	AmrRegionLevelMaxEnum,
	TransientAmrFrequencyEnum,
	/*}}}*/
	ParametersENDEnum,
	/*Coordinate Systems{{{*/
	XYEnum,
	XYZEnum,
	/*}}}*/
	/*Objects {{{*/
	GenericParamEnum,
	BoolInputEnum,
	BoolParamEnum,
	ContourEnum,
	ControlInputEnum,
	DatasetInputEnum,
	DoubleInputEnum,
	DoubleArrayInputEnum,
	DataSetParamEnum,
	DoubleMatArrayParamEnum,
	DoubleMatParamEnum,
	DoubleParamEnum,
	DoubleVecParamEnum,
	ElementEnum,
	ElementHookEnum,
	HookEnum,
	ExternalResultEnum,
	FileParamEnum,
	InputEnum,
	IntInputEnum,
	IntParamEnum,
	IntVecParamEnum,
	TransientParamEnum,
	MaticeEnum,
	MatdamageiceEnum,
	MatenhancediceEnum,
	MatestarEnum,
	MatparEnum,
	NodeEnum,
	NumericalfluxEnum,
	NeumannfluxEnum,
	ParamEnum,
	MoulinEnum,
	PengridEnum,
	PenpairEnum,
	ProfilerEnum,
	MatrixParamEnum,
	MassconEnum,
	MassconaxpbyEnum,
	NodeSIdEnum,
	ElementSIdEnum,
	VectorParamEnum,
	RiftfrontEnum,
	SegmentEnum,
	SegmentRiftfrontEnum,
	SpcDynamicEnum,
	SpcStaticEnum,
	SpcTransientEnum,
	StringArrayParamEnum,
	StringParamEnum,
	SegEnum,
	SegInputEnum,
	TriaEnum,
	TriaInputEnum,
	TetraEnum,
	TetraInputEnum,
	PentaEnum,
	PentaInputEnum,
	VertexEnum,
	VertexPIdEnum,
	VertexSIdEnum,
	/*}}}*/
	/*Options{{{*/
	OptionEnum,
	GenericOptionEnum,
	OptionCellEnum,
	OptionStructEnum,
	/*}}}*/
	/*Solutions and Analyses{{{ */
	AdjointBalancethicknessAnalysisEnum,
	AdjointBalancethickness2AnalysisEnum,
	AdjointHorizAnalysisEnum,
	DefaultAnalysisEnum,
	BalancethicknessAnalysisEnum,
	BalancethicknessSolutionEnum,
	Balancethickness2AnalysisEnum,
	Balancethickness2SolutionEnum,
	BalancethicknessSoftAnalysisEnum,
	BalancethicknessSoftSolutionEnum,
	BalancevelocityAnalysisEnum,
	BalancevelocitySolutionEnum,
	L2ProjectionEPLAnalysisEnum,
	L2ProjectionBaseAnalysisEnum,
	BedSlopeSolutionEnum,
	DamageEvolutionSolutionEnum,
	DamageEvolutionAnalysisEnum,
	StressbalanceAnalysisEnum,
	StressbalanceSIAAnalysisEnum,
	StressbalanceSolutionEnum,
	StressbalanceVerticalAnalysisEnum,
	EnthalpyAnalysisEnum,
	HydrologyShreveAnalysisEnum,
	HydrologyDCInefficientAnalysisEnum,
	HydrologyDCEfficientAnalysisEnum,
	HydrologySommersAnalysisEnum,
	HydrologySolutionEnum,
	MeltingAnalysisEnum,
	MasstransportAnalysisEnum,
	MasstransportSolutionEnum,
	FreeSurfaceBaseAnalysisEnum,
	FreeSurfaceTopAnalysisEnum,
	ExtrudeFromBaseAnalysisEnum,
	ExtrudeFromTopAnalysisEnum,
	DepthAverageAnalysisEnum,
	SealevelriseSolutionEnum,
	SealevelriseAnalysisEnum,
	SteadystateSolutionEnum,
	SurfaceSlopeSolutionEnum,
	SmoothAnalysisEnum,
	ThermalAnalysisEnum,
	ThermalSolutionEnum,
	TransientSolutionEnum,
	UzawaPressureAnalysisEnum,
	GiaSolutionEnum,
	GiaIvinsAnalysisEnum,
	EsaSolutionEnum,
	EsaAnalysisEnum,
	MeshdeformationAnalysisEnum,
	LevelsetAnalysisEnum,
	ExtrapolationAnalysisEnum,
	/*}}}*/
	/*Approximations {{{*/
	ApproximationEnum,
	NoneApproximationEnum,
	SIAApproximationEnum,
	SSAApproximationEnum,
	SSAHOApproximationEnum,
	SSAFSApproximationEnum,
	L1L2ApproximationEnum,
	HOApproximationEnum,
	HOFSApproximationEnum,
	FSApproximationEnum,
	FSvelocityEnum,
	FSpressureEnum,
	/*}}}*/
	/*Gauss{{{*/
	GaussSegEnum,
	GaussTriaEnum,
	GaussTetraEnum,
	GaussPentaEnum,
	/*}}}*/
	/*Interpolation {{{*/
	TriangleInterpEnum,
	BilinearInterpEnum,
	NearestInterpEnum,
	/*}}}*/
	/*Responses{{{*/
	MinVelEnum,
	MaxVelEnum,
	MinVxEnum,
	MaxVxEnum,
	MaxAbsVxEnum,
	MinVyEnum,
	MaxVyEnum,
	MaxAbsVyEnum,
	MinVzEnum,
	MaxVzEnum,
	MaxAbsVzEnum,
	FloatingAreaEnum,
	GroundedAreaEnum,
	IceMassEnum,
	IceVolumeEnum,
	IceVolumeAboveFloatationEnum,
	TotalFloatingBmbEnum,
	TotalGroundedBmbEnum,
	TotalSmbEnum,
	/*}}}*/
	/*Element Interpolations{{{*/
	P0Enum,
	P0ArrayEnum,
	P1Enum,
	P1DGEnum,
	P1bubbleEnum,
	P1bubblecondensedEnum,
	P2Enum,
	P2bubbleEnum,
	P2bubblecondensedEnum,
	P2xP1Enum,
	P1xP2Enum,
	P1xP3Enum,
	P2xP4Enum,
	P1P1Enum,
	P1P1GLSEnum,
	MINIEnum,
	MINIcondensedEnum,
	TaylorHoodEnum,
	LATaylorHoodEnum,
	XTaylorHoodEnum,
	OneLayerP4zEnum,
	CrouzeixRaviartEnum,
	LACrouzeixRaviartEnum,
	/*}}}*/
	/*Rift state {{{*/
	ClosedEnum,
	FreeEnum,
	OpenEnum,
	/*}}}*/
	/*Fill {{{*/
	AirEnum,
	IceEnum,
	MelangeEnum,
	WaterEnum,
	/*}}}*/
	/*Datasets {{{*/
	DataSetEnum,
	ConstraintsEnum,
	LoadsEnum,
	MaterialsEnum,
	NodesEnum,
	ContoursEnum,
	ParametersEnum,
	VerticesEnum,
	ResultsEnum,
	/*}}}*/
	MaximumNumberOfDefinitionsEnum
};

#endif
