function factors=qmu_importancefactors(md,variablename,responsename)
%QMU_IMPORTANCEFACTORS - compute importance factors for a certain variable and response.
%
%   Usage:
%      factors=qmu_importancefactors(md,variablename,responsename)
%
%
%   Example: factors=qmu_importancefactors(md,'drag','max_vel');
%


variablenamelength=length(variablename);

%go through all response functions and find the one corresponding to the correct responsename
responsefunctions=md.dakotaresults.dresp_out;
found=0;
for i=1:length(responsefunctions),
	if strcmpi(responsefunctions(i).descriptor,responsename),
		found=i;
		break;
	end
end
if ~found,
	error('qmu_importancefactors error message: could not find correct response function');
end
responsefunctions=responsefunctions(found);
nfun=size(responsefunctions.var,1);

%Now recover response to the correct design variable
importancefactors=zeros(1,0);
count=0;
for i=1:nfun,
	desvar=responsefunctions.var{i};
	if strncmpi(desvar,variablename,variablenamelength),
		importancefactors(end+1)=responsefunctions.impfac(i);
		count=count+1;
	end
end

if count==0,
	error('qmu_importancefactors error message: could not find to response functions with corresponding design variable');
end

if count==1, %we have scalar
	factors=importancefactors;
	return;
else
	%Ok, get partitioning, unless already supplied
	if isempty(md.part),
		[epart npart]=MeshPartition(md,md.npart);
	else
		npart=md.part+1;
	end

	%distribute importance factor
	factors=importancefactors(npart)';
end

if numel(factors)==md.numberofgrids,
	%get areas for each vertex.
	aire=GetAreas(md.elements,md.x,md.y);
	num_elements_by_node=md.nodeconnectivity(:,end);
	grid_aire=zeros(md.numberofgrids,1);
	for i=1:md.numberofgrids,
		for j=1:num_elements_by_node(i),
			grid_aire(i)=grid_aire(i)+aire(md.nodeconnectivity(i,j));
		end
	end
	factors=factors./grid_aire;
end
