#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#some functions
function timer()
{
	if [[ $# -eq 0 ]]; then
		echo $(date '+%s')
	else
		local  stime=$1
		etime=$(date '+%s')

		if [[ -z "$stime" ]]; then stime=$etime; fi

		dt=$((etime - stime))
		ds=$((dt % 60))
		dm=$(((dt / 60) % 60))
		dh=$((dt / 3600))
		printf '%d:%02d:%02d' $dh $dm $ds
	fi
}
function todaydate()
{
	suffix=`date | awk '{printf("%s-%s-%s  %s",$2,$3,$6,$4);}'`			 
	echo $suffix;			 
} 
function host_name()
{
	#return host name depending on the OS
	if [ "$1" = "winxp32" ] 
	then
		HOST_NAME=`hostname`;
	else
		HOST_NAME=`hostname -s`;
	fi
	echo $HOST_NAME;
} 

#get configs
if [ $# -ne 1 ];
then
	#no config file specified: exit
	echo "no config file specified. Exiting..."
	exit 1
fi
source $1;
export ISSM_DIR
export ISSM_ARCH

#launch nightly run (get start time)
TODAY=$(todaydate);
HOST_NAME=$(host_name $OS);
START_TIME=$(timer);
ISSM_RELEASE="issm";
USER=$(whoami);
INIT_PATH=$(pwd);

#Checkout and install ISSM if required
if [ "$SKIPINSTALLATION" != "yes" ]
then

	#Erase previous code and Fetch the new one
	rm -rf trunk
	svn checkout $REPOSITORY

	#source environment variables with new matlab path
	cd $ISSM_DIR/etc
	source environment.sh MATLAB_DIR=$MATLAB_PATH

	#create simpler  cluster.rc file, with only the cluster we are interested in.
	cat << END > cluster.rc
begin
cluster_name=$HOST_NAME
cluster_codepath=$ISSM_DIR/bin
cluster_executionpath=$EXECUTION_PATH

end
END

	#Install external packages
	if [ "$SKIPPACKAGESCOMPILATION"  = "yes" ]
	then

		#erase externapackages, and link with externalpackages_dir
		cd $ISSM_DIR
		rm -rf externalpackages
		cp -Rf $EXTERNALPACKAGESDIR ./

		rm -rf devpackages
		cp -Rf $DEVPACKAGESDIR ./
	else
		
		cd $ISSM_DIR/externalpackages
		for ep in $EXTERNALPACKAGES
		do 
			cd $ep
			cp configs/$OS/* .
			./install.sh $NUMCPUS_INSTALL
			cd ..
		done

		#3: install automake and autoconf
		cd $ISSM_DIR/devpackages
		make
		cd ..
	fi
else

	#source environment variables with new matlab path
	cd $ISSM_DIR/etc
	source environment.sh MATLAB_DIR=$MATLAB_PATH

fi

#Generate Makefiles and compile ISSM if requested
if [ "$SKIPCOMPILATION" != "yes" ]
then
	cd $ISSM_DIR
	sh scripts/automakererun.sh
	sh configs/$OS/$OS.sh

	#4: compile and install ISSM
	if [ "$OS" = "winxp32" ] 
	then
		cd $ISSM_DIR/src/c
		./intel-compile.sh
		cd $ISSM_DIR/src/mex
		make install
		cd $ISSM_DIR
	else
		make -j $NUMCPUS_INSTALL
		make -j $NUMCPUS_INSTALL install
	fi
fi

#windows environments: ISSM_DIR_WIN variable not correctly picked up when using 
#the cron job. just get startup to take the ISSM_DIR variable as the pwd:
if [ "$OS" = "winxp32" ]
then
	cat startup.m | sed 's/clear status/clear status; ISSM_DIR=pwd;/g' > startup.m.bak
	mv startup.m.bak startup.m
fi

#put installation elapsed time in nightly.log
INSTALL_TIME=$(timer)
ELAPSED_INSTALL=$(timer $START_TIME)
rm -rf $ISSM_DIR/test/Verification/NightlyRun
mkdir  $ISSM_DIR/test/Verification/NightlyRun
cat << END > $ISSM_DIR/test/Verification/NightlyRun/nightly.log
today:     $(echo $TODAY)
user:      $(echo $USER)
host:      $(echo $HOST_NAME)
OS:        $(echo $OS)
release:   $(echo $ISSM_RELEASE)
init_path: $(echo $INIT_PATH)
elapsed_install: $(echo $ELAPSED_INSTALL)
END

#Launch matlab and the nightly run script
cd $ISSM_DIR/cron/
./run.sh $1
ELAPSED_RUN=$(timer $INSTALL_TIME)
ELAPSED_TOTAL=$(timer $START_TIME)
cat << END >>  $ISSM_DIR/test/Verification/NightlyRun/nightly.log
elapsed_run:   $(echo $ELAPSED_RUN)
elapsed_total: $(echo $ELAPSED_TOTAL)
END

#Build html report
cd $ISSM_DIR/cron/
./report.sh
echo "html report located in $ISSM_DIR/test/Verification/NightlyRun/report.html"
exit
		
#send mail if requested
if [ "$SKIPMAIL" != "yes" ]
then
	echo "sending report..."
	source $ISSM_DIR/cron/mailinglist
	for i in `echo $MAILINGLIST`; do

		if [ "$OS" = "winxp32" ]
		then
			email -html -f "ISSM Nightly run $EMAIL_ADRESS" -s "Nightly runs of $ISSM_RELEASE , operating system: $OS. " $i < $ISSM_DIR/test/Verification/NightlyRun/report.html
		else 
			if [ "$OS" = "linux64" ]
			then
				cat - $ISSM_DIR/test/Verification/NightlyRun/report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" <$EMAIL_ADRESS>
To: $i
Subject: Nightly runs of $ISSM_RELEASE, operating system: $OS.
Mime-Version: 1.0
Content-Type: text/html
HERE
		else
cat - $ISSM_DIR/test/Verification/NightlyRun/report.html <<HERE | /usr/sbin/sendmail  -oi -t
From: "ISSM Nightly run" <$EMAIL_ADRESS>
To: $i
Subject: Nightly runs of $ISSM_RELEASE, operating system: $OS.
Mime-Version: 1.0
Content-Type: text/html
HERE
			fi
		fi
	done
fi
