/*!\file FourierLoveCorex
 * \brief: core solution module for love analysis. Based on Caron's fortran core. 
 */

#include "./FourierLoveCorex.h"

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "../../toolkits/toolkits.h"
#include "../InputUpdateFromConstantx/InputUpdateFromConstantx.h"

extern "C" { 
	int lnb_setup_( IssmDouble* LoveKr, IssmDouble* LoveKi, IssmDouble* LoveHr, IssmDouble* LoveHi, IssmDouble* LoveLr, 
		IssmDouble* LoveLi, int* pnfreq, IssmDouble* frequencies, int* psh_nmax, int* psh_nmin, 
		IssmDouble* pg0, IssmDouble* pr0, IssmDouble* pmu0,bool* pallow_layer_deletion, int* pforcing_type, bool* pverbosemod,
		int* pnumlayers, IssmDouble* radius, IssmDouble* viscosity, IssmDouble* lame_lambda, IssmDouble* lame_mu, 
		IssmDouble* burgers_viscosity, IssmDouble* burgers_mu, IssmDouble* density, IssmDouble* isburgers, IssmDouble* issolid);

}

void FourierLoveCorex( IssmDouble* LoveKr, IssmDouble* LoveKi, IssmDouble* LoveHr, IssmDouble* LoveHi, IssmDouble* LoveLr, 
		IssmDouble* LoveLi, int nfreq, IssmDouble* frequencies, int sh_nmax, int sh_nmin, 
		IssmDouble g0, IssmDouble r0, IssmDouble mu0,bool allow_layer_deletion, int forcing_type, bool verbosemod,
		int numlayers, IssmDouble* radius, IssmDouble* viscosity, IssmDouble* lame_lambda, IssmDouble* lame_mu, 
		IssmDouble* burgers_viscosity, IssmDouble* burgers_mu, IssmDouble* density, IssmDouble* isburgers, IssmDouble* issolid){

	/*Call fortran driver: */
	lnb_setup_(  LoveKr,  LoveKi,  LoveHr,  LoveHi,  LoveLr, 
		 LoveLi,  &nfreq,  frequencies,  &sh_nmax,  &sh_nmin, 
		 &g0,  &r0,  &mu0, &allow_layer_deletion,  &forcing_type, &verbosemod,
		 &numlayers,  radius,  viscosity,  lame_lambda,  lame_mu, 
		 burgers_viscosity,  burgers_mu,  density,  isburgers,  issolid);
}
