module lnb_param

 implicit none
 
 public 

 !Physical Constants
 double precision, parameter :: GG = 6.67259e-11! gravitational constant
 double precision :: ra,rb,rc ! radii of the surface, CMB and ICB
 double precision :: pi,ro_mean,go_surf,go_icb,go_cmb !some constants
 ! GG --> gravitational constant
 ! ra, rb, rc --> Surface, CMB and ICB radius
 ! ro_mean --> mean density of the planet 
 ! go_surf --> mean surface gravity
 ! go_icb/cmb --> gravity at the Inner Core/Core-Mantle Boundary
 double precision   :: mu0,go0,r0 !3 normalization constants

!Numerical Constants
 double precision :: epsdb, layerrap !used in detecting underflows in the lovenb integration
 double complex     :: valini,freq ! integration constant and angular frequency being processed
 logical :: allow_layer_del,display, benchmark_spada !do we allow deletion of layers in case of underflow, enable some prints in terminal

!GIA problem setup
 integer :: deg,ifmin,ifmax ! deg=SH degree, ifmin/ifmax=which kind of forcing is applied (usually we want loading)
 logical :: incompressible !choose which mode of calculation is activated

!Earth Model 
 integer :: nfreq, degmax, degmin
 integer :: nlayer! number of layers
 double precision, dimension(:), pointer :: roc,lac,muc,vic,vic2,muc2 ! Earth layers parameters
 double precision, dimension(:), pointer :: radius ! Earth layers parameters
 double precision :: vicratio,mucratio !2 Burgers long-term to short-term ratios
 logical, dimension(:), pointer :: soliddim,radbc,burgers ! is this layer solid (if not it's liquid), does it have specific boundary conditions and does it have a Burgers rheology (if not, it uses Maxwell)
 
end module lnb_param
