/*!\file Matlitho.c
 * \brief: implementation of the Matlitho object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"

/*Matlitho constructors and destructor*/
Matlitho::Matlitho(){/*{{{*/
	this->numlayers=0;
	this->radius=NULL;
	this->viscosity=NULL;
	this->lame_lambda=NULL;
	this->lame_mu=NULL;
	this->burgers_viscosity=NULL;
	this->burgers_mu=NULL;
	this->density=NULL;
	this->isburgers=NULL;
	this->issolid=NULL;
	return;
}
/*}}}*/
Matlitho::Matlitho(int matlitho_mid, IoModel* iomodel){/*{{{*/

	IssmDouble* isburgersd=NULL;
	IssmDouble* issolidd=NULL;

	this->mid=matlitho_mid;
	iomodel->FindConstant(&this->numlayers,"md.materials.numlayers");

	this->radius=xNew<IssmDouble>(this->numlayers+1);
	xMemCpy<IssmDouble>(this->radius, iomodel->Data("md.materials.radius"),this->numlayers+1);
	
	this->viscosity=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->viscosity, iomodel->Data("md.materials.viscosity"),this->numlayers);
	
	this->lame_lambda=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->lame_lambda, iomodel->Data("md.materials.lame_lambda"),this->numlayers);
	
	this->lame_mu=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->lame_mu, iomodel->Data("md.materials.lame_mu"),this->numlayers);

	this->burgers_viscosity=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->burgers_viscosity, iomodel->Data("md.materials.burgers_viscosity"),this->numlayers);

	this->burgers_mu=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->burgers_mu, iomodel->Data("md.materials.burgers_mu"),this->numlayers);

	this->density=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->density, iomodel->Data("md.materials.density"),this->numlayers);

	this->isburgers=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->isburgers, iomodel->Data("md.materials.isburgers"),this->numlayers);

	this->issolid=xNew<IssmDouble>(this->numlayers);
	xMemCpy<IssmDouble>(this->issolid, iomodel->Data("md.materials.issolid"),this->numlayers);
	
	/*isburgersd= xNew<IssmDouble>(this->numlayers);
	this->isburgers=xNew<bool>(this->numlayers);
	xMemCpy<IssmDouble>(isburgersd, iomodel->Data("md.materials.isburgers"),this->numlayers);
	for (int i=0;i<this->numlayers;i++)this->isburgers[i]=reCast<bool,IssmDouble>(isburgersd[i]);
	
	issolidd= xNew<IssmDouble>(this->numlayers);
	this->issolid=xNew<bool>(this->numlayers);
	xMemCpy<IssmDouble>(issolidd, iomodel->Data("md.materials.issolid"),this->numlayers);
	for (int i=0;i<this->numlayers;i++)this->issolid[i]=reCast<bool,IssmDouble>(issolidd[i]);*/
	
	/*free ressources: */
	xDelete<IssmDouble>(isburgersd);
	xDelete<IssmDouble>(issolidd);
}
/*}}}*/
Matlitho::~Matlitho(){/*{{{*/
	
	xDelete<IssmDouble>(radius);
	xDelete<IssmDouble>(viscosity);
	xDelete<IssmDouble>(lame_lambda);
	xDelete<IssmDouble>(lame_mu);
	xDelete<IssmDouble>(burgers_viscosity);
	xDelete<IssmDouble>(burgers_mu);
	xDelete<IssmDouble>(density);
	xDelete<IssmDouble>(isburgers);
	xDelete<IssmDouble>(issolid);

	return;
}
/*}}}*/
void Matlitho::SetMid(int matlitho_mid){/*{{{*/
	this->mid=matlitho_mid;
}
/*}}}*/

/*Object virtual functions definitions:*/
Object* Matlitho::copy() {/*{{{*/

	/*Output*/
	Matlitho* matlitho;

	/*Initialize output*/
	matlitho=new Matlitho(*this);

	/*copy fields: */
	matlitho->mid=this->mid;
	matlitho->numlayers=this->numlayers;
	if(matlitho->numlayers){
		matlitho->radius=xNew<IssmDouble>(this->numlayers+1); xMemCpy<IssmDouble>(matlitho->radius, this->radius,this->numlayers+1);
		matlitho->viscosity=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->viscosity, this->viscosity,this->numlayers);
		matlitho->lame_lambda=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->lame_lambda, this->lame_lambda,this->numlayers);
		matlitho->lame_mu=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->lame_mu, this->lame_mu,this->numlayers);
		matlitho->burgers_viscosity=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->burgers_viscosity, this->burgers_viscosity,this->numlayers);
		matlitho->burgers_mu=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->burgers_mu, this->burgers_mu,this->numlayers);
		matlitho->density=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->density, this->density,this->numlayers);
		matlitho->isburgers=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->isburgers, this->isburgers,this->numlayers);
		matlitho->issolid=xNew<IssmDouble>(this->numlayers); xMemCpy<IssmDouble>(matlitho->issolid, this->issolid,this->numlayers);
		/*matlitho->isburgers=xNew<bool>(this->numlayers); for(int i=0;i<this->numlayers;i++)matlitho->isburgers[i]=this->isburgers[i]; 
		matlitho->issolid=xNew<bool>(this->numlayers); for(int i=0;i<this->numlayers;i++)matlitho->issolid[i]=this->issolid[i];*/ 
	}

	return matlitho;
}
/*}}}*/
void Matlitho::DeepEcho(void){/*{{{*/

	this->Echo();
}		
/*}}}*/
void Matlitho::Echo(void){/*{{{*/

	_printf_("Matlitho:\n");
	_printf_("   mid: " << mid << "\n");
	_printf_("   numlayers: " << numlayers << "\n");
	_printf_("layer radius viscosity lame_lambda lame_mu burgers_viscosity burgers_mu density isburgers issolid\n");
	for (int i=0;i<numlayers;i++){
		_printf_(i << " " << radius[i] << " " << viscosity[i] << " " << lame_lambda[i] << " " << lame_mu[i] << " " << burgers_viscosity[i] << " " << burgers_mu[i] << " " << density[i] << " " << isburgers[i] << " " << issolid[i]);
	}
	return;
}
/*}}}*/
int  Matlitho::Id(void){ return mid; }/*{{{*/
/*}}}*/
void Matlitho::Marshall(char** pmarshalled_data,int* pmarshalled_data_size, int marshall_direction){ /*{{{*/

	MARSHALLING_ENUM(MatlithoEnum);

	MARSHALLING(numlayers);
	if(numlayers) { 
		MARSHALLING_DYNAMIC(radius,IssmDouble,numlayers+1);
		MARSHALLING_DYNAMIC(viscosity,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(lame_lambda,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(lame_mu,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(burgers_viscosity,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(burgers_mu,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(density,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(isburgers,IssmDouble,numlayers);
		MARSHALLING_DYNAMIC(issolid,IssmDouble,numlayers);
	}
	else{
		radius=NULL;
		viscosity=NULL;
		lame_lambda=NULL;
		lame_mu=NULL;
		burgers_viscosity=NULL;
		burgers_mu=NULL;
		density=NULL;
		isburgers=NULL;
		issolid=NULL;
	}

}
/*}}}*/
int  Matlitho::ObjectEnum(void){/*{{{*/

	return MatlithoEnum;

}
/*}}}*/

/*Update virtual functions definitions:*/

/*Matlitho management: */
void       Matlitho::Configure(Elements* elementsin){/*{{{*/
	/*don't do anything, we don't have a hook to an element! As there is only 
	 * one Matlitho object!*/
}
/*}}}*/
void       Matlitho::ResetHooks(){/*{{{*/
	/*don't do anything, we don't have a hook to an element! As there is only 
	 * one Matlitho object!*/
	return;
}
/*}}}*/
