#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of petsc
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/petsc-//g'`

#Some cleanup
rm -rf install petsc-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  petsc-$version.tar.gz

#Move petsc to install directory
rm -rf install/*
mv petsc-$version/* install/
rm -rf petsc-$version

#Configure petsc
cd install
./config/configure.py  --prefix="$ISSM_DIR/externalpackages/petsc/install" --with-mpi-dir=$ISSM_DIR/externalpackages/mpich2/install --PETSC_ARCH=linux-gnu-amd64 --PETSC_DIR="$ISSM_DIR/externalpackages/petsc/install" --with-fc=gfortran --with-debugging=0 --with-shared=1 --download-mumps=yes --download-scalapack=yes --download-blacs=yes --download-blas=yes --download-f-blas-lapack=yes --FFLAGS=-I$ISSM_DIR/externalpackages/mpich2/install/include --download-plapack=yes

#Compile petsc
make  -j $NUMCPUS

#Install
make install
