/*!\file ProcessParamsx
 * \brief: process parameters using partitioning vector
 */

#include "./ProcessParamsx.h"

#undef __FUNCT__ 
#define __FUNCT__ "ProcessParamsx"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ProcessParamsx( DataSet* parameters, Vec  part){

	int i;
	
	double* partition=NULL;
	Param*  param=NULL;

	/*diagnostic: */
	double* vx=NULL;
	double* vy=NULL;
	double* vz=NULL;
	
	double* u_g=NULL;
	
	/*control: */
	Vec     vec_vx_obs=NULL;
	Vec     vec_vy_obs=NULL;
	Vec     vec_control_parameter=NULL;

	double* vx_obs=NULL;
	double* vy_obs=NULL;
	double* control_parameter=NULL;

	double* u_g_obs=NULL;
	double* p_g=NULL;
	

	/*diverse: */
	int     numberofnodes;
	int     analysis_type;
	int     count;

	parameters->FindParam((void*)&analysis_type,"analysis_type");
	count=parameters->Size();
		
	parameters->FindParam((void*)&numberofnodes,"numberofnodes");

	/*First serialize partition vector: */
	VecToMPISerial(&partition,part);
	
	
	if (   (analysis_type==ControlAnalysisEnum()) || 
	       (analysis_type==DiagnosticHorizAnalysisEnum()) || 
	       (analysis_type==DiagnosticVertAnalysisEnum()) || 
	       (analysis_type==DiagnosticStokesAnalysisEnum()) 
	   ){

		parameters->FindParam((void*)&vx,"vx");
		parameters->FindParam((void*)&vy,"vy");
		parameters->FindParam((void*)&vz,"vz");

		u_g=(double*)xcalloc(numberofnodes*3,sizeof(double));

		if(vx){
			for(i=0;i<numberofnodes;i++){
				u_g[(int)(3*partition[i]+0)]=vx[i];  
			}
		}

		if(vy){
			for(i=0;i<numberofnodes;i++){
				u_g[(int)(3*partition[i]+1)]=vy[i];  
			}
		}

		if(vz){
			for(i=0;i<numberofnodes;i++){
				u_g[(int)(3*partition[i]+2)]=vz[i];  
			}
		}


		/*Now, create new parameters: */
		count++;
		param= new Param(count,"u_g",DOUBLEVEC);
		param->SetDoubleVec(u_g,3*numberofnodes);
		parameters->AddObject(param);

		/*erase old parameters: */
		param=(Param*)parameters->FindParamObject("vx");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("vy");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("vz");
		parameters->DeleteObject((Object*)param);

	}


	if(analysis_type==ControlAnalysisEnum()){

		parameters->FindParam((void*)&vx_obs,"vx_obs");
		parameters->FindParam((void*)&vy_obs,"vy_obs");
		parameters->FindParam((void*)&control_parameter,"control_parameter");

		/*Now, from vx_obs and vy_obs, build u_g_obs, correctly partitioned: */

		u_g_obs=(double*)xcalloc(numberofnodes*2,sizeof(double));
		p_g=(double*)xcalloc(numberofnodes*2,sizeof(double));

		for(i=0;i<numberofnodes;i++){
			u_g_obs[(int)(2*partition[i]+0)]=vx_obs[i];  
			u_g_obs[(int)(2*partition[i]+1)]=vy_obs[i];  
			p_g[(int)(2*partition[i]+0)]=control_parameter[i];
		}

		/*Now, create new parameters: */
		count++;
		param= new Param(count,"u_g_obs",DOUBLEVEC);
		param->SetDoubleVec(u_g_obs,2*numberofnodes);
		parameters->AddObject(param);

		count++;
		param= new Param(count,"p_g",DOUBLEVEC);
		param->SetDoubleVec(p_g,2*numberofnodes);
		parameters->AddObject(param);

		/*erase old parameter: */
		param=(Param*)parameters->FindParamObject("vx_obs");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("vy_obs");
		parameters->DeleteObject((Object*)param);

		param=(Param*)parameters->FindParamObject("control_parameter");
		parameters->DeleteObject((Object*)param);

	}

	xfree((void**)&partition);
	
	xfree((void**)&vx);
	xfree((void**)&vy);
	xfree((void**)&vz);
	xfree((void**)&u_g);

	xfree((void**)&vx_obs);
	xfree((void**)&vy_obs);
	xfree((void**)&control_parameter);
	xfree((void**)&u_g_obs);
	xfree((void**)&p_g); 

}
