#!/bin/sh

#Stallo configuration script
#this uses system stuff, you need to load the following:
# module load Automake/1.15-intel-2016a
# module load libtool/2.4.6-intel-2016a
# module load CMake/3.5.2-intel-2016a
# module load intel/2016a
# module load ParMETIS/4.0.3-intel-2016a
# module load MUMPS/5.1.1-intel-2016a-parmetis
# module load PETSc/3.7.2-intel-2016a-Python-2.7.11
# module load FFTW/3.3.4-intel-2016a
# module load OpenSSL/1.0.1s-intel-2016a


./configure \
    --prefix=$ISSM_DIR \
    --without-kriging \
    --with-wrappers=no \
    --with-petsc-dir="/global/hds/software/cpu/eb3/PETSc/3.7.2-intel-2016a-Python-2.7.11" \
    --with-triangle-dir="$ISSM_DIR/externalpackages/triangle/install" \
    --with-mpi-include="/global/hds/software/cpu/eb3/impi/5.1.2.150-iccifort-2016.1.150-GCC-4.9.3-2.25/include64" \
    --with-mpi-libflags="-L/global/hds/software/cpu/eb3/impi/5.1.2.150-iccifort-2016.1.150-GCC-4.9.3-2.25/lib64 -lmpich -lmpichf90 -lmpichcxx -lmpl" \
    --with-metis-dir="/global/hds/software/cpu/eb3/ParMETIS/4.0.3-intel-2016a/include" \
    --with-mumps-dir="/global/hds/software/cpu/eb3/MUMPS/5.1.1-intel-2016a-parmetis" \
    --with-m1qn3-dir="$ISSM_DIR/externalpackages/m1qn3/install" \
    --with-hypre-dir="/global/hds/software/cpu/eb3/Hypre/2.11.1-intel-2016a" \
    --with-mkl-libflags="-L/global/hds/software/cpu/eb3/imkl/11.3.1.150-iimpi-8.1.5-GCC-4.9.3-2.25/mkl/lib/intel64 -lmkl_blacs_intelmpi_lp64 -lmkl_intel_lp64 -lmkl_intel_thread -lmkl_core -liomp5 -lpthread -lmkl_scalapack_lp64 -L/global/hds/software/cpu/eb3/FFTW/3.3.4-intel-2016a/lib/ -lfftw3_mpi -L/global/hds/software/cpu/eb3/SuiteSparse/4.5.3-intel-2016a-ParMETIS-4.0.3/lib -lklu -lamd -lamd -lbtf -lsuitesparseconfig -lumfpack -lcholmod -L/global/hds/software/cpu/eb3/ifort/2016.1.150-GCC-4.9.3-2.25/lib/intel64 -lifcore -lifport -L/global/hds/software/cpu/eb3/OpenSSL/1.0.1s-intel-2016a/lib -lssl -L/global/hds/software/cpu/eb3/SCOTCH/6.0.4-intel-2016a/lib -lesmumps -lptesmumps  -lptscotch  -lptscotcherr  -lptscotcherrexit -lscotch -lscotcherr -lscotcherrexit -lscotch_group" \
    --enable-development
