#ifndef AMRBAMG
#define AMRBAMG

/*Includes*/
#include "../shared/shared.h"
#include "../toolkits/toolkits.h"

#include "../bamg/BamgMesh.h"
#include "../bamg/BamgGeom.h"
#include "../bamg/BamgOpts.h"

class AmrBamg{

	public:
		int fieldenum;
		int keepmetric;
		IssmDouble groundingline_resolution;
		IssmDouble groundingline_distance;
		IssmDouble icefront_resolution;
		IssmDouble icefront_distance;
		IssmDouble thicknesserror_resolution;
		IssmDouble thicknesserror_threshold;
		IssmDouble deviatoricerror_resolution;
		IssmDouble deviatoricerror_threshold;

		/* Constructor, destructor etc*/
		AmrBamg(IssmDouble hmin,IssmDouble hmax,int fieldenum_in,IssmDouble err_in,int keepmetric_in,IssmDouble gradation_in,
            		IssmDouble groundingline_resolution_in,IssmDouble groundingline_distance_in,
                  IssmDouble icefront_resolution_in,IssmDouble icefront_distance_in,
                  IssmDouble thicknesserror_resolution_in,IssmDouble thicknesserror_threshold_in,
                  IssmDouble deviatoricerror_resolution_in,IssmDouble deviatoricerror_threshold_in);
		~AmrBamg();

		/*General methods*/
		void Initialize(int* elements,IssmDouble* x,IssmDouble* y,int numberofvertices,int numberofelements);
		void ExecuteRefinementBamg(IssmDouble* field,IssmDouble* hmaxVertices,int* pnewnumberofvertices,int *pnewnumberofelements,IssmDouble** px,IssmDouble** py,IssmDouble** pz,int** pelementslist);

	private:
		BamgGeom* geometry;
		BamgMesh* fathermesh;
		BamgMesh* previousmesh;
		BamgOpts* options;
};

#endif
