#!/bin/bash
set -eu

#Some cleanup
rm -rf src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/emsdk-portable.tar.gz' 'emsdk-portable.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  emsdk-portable.tar.gz
mv emsdk_portable src

cd src 

export CXX=g++
export CC=gcc

./emsdk update
./emsdk install latest
./emsdk activate latest

#Related to moving the install path after installation - However, not safe to install in dir named "install" since a failure would not be noticed by jenkins when triggering
#Not reliable - when executed in subshell without sourcing the install file, this has no effect. Safer to explicitly source for each dependent externalpackage.
source emsdk_env.sh
