#!/bin/bash
#generate html report from nightly.log output file

cd $ISSM_DIR/test/Verification/NightlyRun/

#process nightly.log
TODAY=`     cat nightly.log | grep "today"           | awk '{printf("%s %s",$2,$3);}'`
USER=`      cat nightly.log | grep "user"            | awk '{print $2}'`
HOST_NAME=` cat nightly.log | grep "host"            | awk '{print $2}'`
OS=`        cat nightly.log | grep "OS"              | awk '{print $2}'`
RELEASE=`   cat nightly.log | grep "release"         | awk '{print $2}'`
EL_INSTALL=`cat nightly.log | grep "elapsed_install" | awk '{print $2}'`
EL_RUN=`    cat nightly.log | grep "elapsed_run"     | awk '{print $2}'`
EL_TOTAL=`  cat nightly.log | grep "elapsed_total"   | awk '{print $2}'`

#Process matlab_log.log
cat matlab_log.log         | egrep 'ERROR|SUCCESS|FAILURE'          > matlab.log
NUM_TOT=`wc -l matlab.log | awk '{print $1}'`
NUM_ERR=`cat matlab.log | grep 'ERROR'   | grep -v "PETSC ERROR" | wc -l`
NUM_SUC=`cat matlab.log | grep 'SUCCESS' | wc -l`
NUM_FAI=`cat matlab.log | grep 'FAILURE' | wc -l`

#style
H1_STYLE='width="1000px" cellpadding="20"'
H1_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-weight: bold; font-size:35px;" align="center"'

H2_STYLE='width="900px" cellpadding="20"'
H2_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-size:28px; font-weight: bold;" align="left"'

TABLE_STYLE='width="800px" rules=none bgcolor="#ffffdd" border=1 bordercolor="#000000" cellpadding="3"'
TABLE_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14; font-weight: normal;" align="left"'

MATLAB_STYLE='width="1000px" rules=none'
MATLAB_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px; font-weight: normal;" align="left"'

BODY_STYLE='width="1000px"'
BODY_FONT="style=\"color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px;\""

FOOTER_STYLE='width="800px"  cellpadding="10"'
FOOTER_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:12px; font-weight: normal;" align="center"'

#style 2
BODY_FONTC=`echo $BODY_FONT | sed -e "s/style=\"/style=\"text-align:center; /g"`
BODY_FONTL=`echo $BODY_FONT | sed -e "s/style=\"/style=\"text-align:left; /g"`

#create some variables
if [ $(ls -1 $ISSM_DIR/bin | wc -l) -le 20 ];
then
	IS_INSTALL=0
else
	IS_INSTALL=1
fi
if [ $(wc -l matlab.log | awk '{printf("%s",$1);}')  -eq 0 ] 
then
	IS_RUN=0
else
	IS_RUN=1
fi

#build report.html

#first: summary
cat << END > summary.html
<div align="center">
<table $H1_STYLE><tr><td $H1_FONT>ISSM Nightly run report</td></tr></table>

<table $TABLE_STYLE>
<tr> 
<td $TABLE_FONT>host: $HOST_NAME</td>
<td $TABLE_FONT>date: $TODAY</td>
</tr>
<tr>
<td $TABLE_FONT>OS: $OS</td>
<td $TABLE_FONT>user: $USER</td>
</tr>
<tr>
<td $TABLE_FONT>status: STATUS</td>
<td $TABLE_FONT>release: $RELEASE</td>
</tr>
<tr>
<td $TABLE_FONT>number of success: $NUM_SUC/$NUM_TOT
<td $TABLE_FONT>total elapsed time: $EL_TOTAL</td>
</tr>
<tr>
<td $TABLE_FONT>number of errors: $NUM_ERR/$NUM_TOT

<td $TABLE_FONT>installation elapsed time: $EL_INSTALL</td>
</tr>
<tr>
<td $TABLE_FONT>number of failures: $NUM_FAI/$NUM_TOT
<td $TABLE_FONT>installation elapsed time: $EL_INSTALL</td>
</tr>
</table>
<br><hr width="1000px">
END

#update status
if [ $IS_RUN -eq 1 ]
then
	cat summary.html | sed -e "s/STATUS/<span style=\"color:#008000\">all test desks have been run<\/span>/g" > summary2.html
	mv summary2.html summary.html
else
	if [ $IS_INSTALL -eq 1 ]
	then
		cat summary.html | sed -e "s/STATUS/<span style=\"color:#ff0000\">installation successful but tests runs failed<\/span>/g" > summary2.html
		mv summary2.html summary.html
	else
		cat summary.html | sed -e "s/STATUS/<span style=\"color:#ff0000\">installation failed<\/span>/g" > summary2.html
		mv summary2.html summary.html
	fi
fi

#Matlab error report
if [ -e matlaberror.log ]
then
cat << END > matlaberror.html
<table $H2_STYLE><tr><td $H2_FONT>Matlab error</td></tr></table>
<table $MATLAB_STYLE><tr><td $MATLAB_FONT>
<pre>$(more matlaberror.log)</pre>
</td></tr></table>
END
else
	mktemp matlaberror.html
fi

#report content
if [ $IS_INSTALL -eq 1 ];
then
	cat << END > content.html
<table $(echo $H2_STYLE)><tr><td $(echo $H2_FONT)>List of tests</td></tr></table>
<table $(echo $BODY_STYLE) cellspacing="-1">
<tr> 
<th $(echo $BODY_FONT)>Result</th> 
<th $(echo $BODY_FONT)>Tolerance</th> 
<th $(echo $BODY_FONT)>Test name</th>  
<th $(echo $BODY_FONT)>Analysis type</th> 
<th $(echo $BODY_FONT)>Sub type</th> 
<th $(echo $BODY_FONT)>Qmu</th>
<th $(echo $BODY_FONT)>control</th>
<th $(echo $BODY_FONT)>Control fit</th>
<th $(echo $BODY_FONT)>Parallel</th>
<th $(echo $BODY_FONT)>Field checked</th>
</tr>
$(cat matlab.log | while read line
  do
	  echo "<tr>"

	  #get status
	  STATUS=`echo $line | awk '{print $1}'`

	  #FAILURE
	  if [ "$STATUS" = "FAILURE" ]
	  then

		  FONTC=$(echo "$BODY_FONTC bgcolor=#ffff00");
		  FONTL=$(echo "$BODY_FONTL bgcolor=#ffff00");
		  echo $line | awk -v FONTC="$FONTC" -v FONTL="$FONTL" '
		  { printf("<td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td>",FONTL,$1,FONTC,"N/A",FONTL,$3,FONTL,$5,FONTL,$7,FONTC,$9,FONTC,$11,FONTC,$13,FONTC,$15,FONTC,"N/A");}
			  '; 

		  else

		  #SUCCESS
		  if [ "$STATUS" = "SUCCESS" ]
		  then
			  color="bgcolor=#ddffdd";

		  #ERROR
		  else
			  color="bgcolor=#ffdddd";
		  fi

		  FONTC=$(echo "$BODY_FONTC $color")
		  FONTL=$(echo "$BODY_FONTL $color")
		  echo $line | awk -v FONTC="$FONTC" -v FONTL="$FONTL" '
		  { printf("<td %s>%s</td><td %s>%s%s%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td>",FONTL,$1,FONTL,$3,$4,$5,FONTL,$7,FONTL,$9,FONTL,$11,FONTC,$13,FONTC,$15,FONTC,$17,FONTC,$19,FONTL,$21);}
			  '; 
	  fi

	  echo "</tr>"

  done
	  )
</table>
<br>
END
else
	mktemp content.html
fi

#last footer
cat << END > footer.html
<br>
<table $FOOTER_STYLE><tr><td $FOOTER_FONT><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</td></tr></table>
</div>
END

#concatenate files
cat summary.html matlaberror.html content.html footer.html > report.html
rm  summary.html content.html footer.html matlaberror.html matlab.log
