/*!\file:  issm_ocean.cpp
 * \brief: ISSM OCEAN main program. 
 */ 

#include "./issm.h"

int main(int argc,char **argv){

	/*diverse:*/
	int    icecommsize;
	int    rankzeros[2];
	int    my_rank;
	ISSM_MPI_Comm worldcomm;

//	int    modelid;
//	int    count=0;
	ISSM_MPI_Comm modelcomm;
	ISSM_MPI_Comm frommitgcm;
	ISSM_MPI_Comm tomitgcmcomm;

	/*Initialize exception trapping: */
	ExceptionTrapBegin();

	/*Initialize environment (MPI, PETSC, MUMPS, etc ...)*/
	worldcomm=EnvironmentInit(argc,argv);
	
	/*What is my rank?:*/
	ISSM_MPI_Comm_rank(worldcomm,&my_rank);

	/*First model is ice, second is ocean*/
	/*ice comm size: */
	icecommsize=(int) strtol(argv[2], (char **)NULL, 10);

	/*Buil array of who is rank 0 of their own group:*/
	rankzeros[0]=0; 
	rankzeros[1]=icecommsize; 

	/*Split world into sub-communicators for each and every model:*/
	ISSM_MPI_Comm_split(worldcomm,0, my_rank, &modelcomm);

	ISSM_MPI_Intercomm_create( modelcomm, 0, worldcomm, rankzeros[1], 0, &tomitgcmcomm); 

	/*Initialize femmodel from arguments provided command line: */
	FemModel *femmodel = new FemModel(argc,argv,modelcomm);
	
	/*Now that the models are initialized, keep communicator information in the parameters datasets of each model: */
	femmodel->parameters->AddObject(new GenericParam<ISSM_MPI_Comm>(worldcomm,WorldCommEnum));
	femmodel->parameters->AddObject(new GenericParam<ISSM_MPI_Comm>(tomitgcmcomm,ToMITgcmCommEnum));

	/*Solve: */
	femmodel->Solve();

	/*Output results: */
	OutputResultsx(femmodel);

	/*Wrap up: */
	femmodel->CleanUp();

	/*Delete Model: */
	delete femmodel;

	/*Finalize environment:*/
	EnvironmentFinalize();

	/*Finalize exception trapping: */
	ExceptionTrapEnd();

	/*Free ressources:*/
//	xDelete<int>(commsizes);

	/*Return unix success: */
	return 0; 
}
