#!/bin/bash
#generate html report from nightly.log output file

#Process log
cat nightly.log | grep 'ERROR'   | grep -v "PETSC ERROR" > errors.log
cat nightly.log | grep 'SUCCESS'                         > success.log
cat nightly.log | grep 'FAILURE'                         > failures.log

#create some variables
if [ $(ls -1 $ISSM_DIR/bin | wc -l) -le 20 ];
then
	IS_INSTALL=0
else
	IS_INSTALL=1
fi
if [ $(wc -l nightly.log | awk '{printf("%s",$1);}')  -eq 0 ] 
then
	IS_RUN=0
else
	IS_RUN=1
fi

#style
H1_STYLE='width="800px" cellpadding="20"'
H1_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-weight: bold; font-size:35px;" align="center"'

H2_STYLE='width="840px" cellpadding="20"'
H2_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-size:28px; font-weight: bold;" align="left"'

TABLE_STYLE='width="820px" rules=none bgcolor="#ffffdd" border=1 bordercolor="#000000" cellpadding="3"'
TABLE_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14; font-weight: normal;" align="left"'

MATLAB_STYLE='width="820px" rules=none'
MATLAB_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px; font-weight: normal;" align="left"'

BODY_STYLE='width="820px"'
BODY_FONT="style=\"color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px;\""

NOTEST_STYLE='width="650px"'
NOTEST_FONT='style="color:#FF0000; font-family:Arial, Verdana, Tahoma; font-size:14px;" align="left"'

FOOTER_STYLE='width="800px"  cellpadding="10"'
FOOTER_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:12px; font-weight: normal;" align="center"'

#build report.html

#first: summary
cat << END > summary.html
<div align="center">
<table $H1_STYLE><tr><td $H1_FONT>ISSM Nightly run report</td></tr></table>

<table $TABLE_STYLE>
<tr> 
<td $TABLE_FONT>host: $HOST_NAME</td>
<td $TABLE_FONT>date: $TODAY</td>
</tr>
<tr>
<td $TABLE_FONT>user: $(whoami)</td>
<td $TABLE_FONT>total elapsed time: $ELAPSED_TOTAL</td>
</tr>
<tr>
<td $TABLE_FONT>OS: $OS</td>
<td $TABLE_FONT>installation elapsed time: $ELAPSED_INSTAL</td>
</tr>
<tr>
$(#print status
if [ $(echo $IS_INSTALL) -eq 0 ];
then
	#installation failed, end of report
	echo "<td $TABLE_FONT>status: <span style=\"color:#FF0000\">installation failed</span></td>"
	echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
	echo "</tr>"
	echo "</table>"
	rm errors.log success.log
else
	#installation successful. Did we go to the end?

	if [ $(echo $IS_RUN) -eq 0 ];
	then
		#run failed, end of report
		echo "<td $TABLE_FONT>status: <span style=\"color:#FF0000\">installation successful but tests runs failed</span></td>"
		echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
		echo "</tr>"
		echo "</table>"
		rm errors.log success.log failures.log 

	else

		echo "<td $TABLE_FONT>status: <span style=\"color:#008000\">all test desks have been run</span></td>"
		echo "<td $TABLE_FONT>execution elapsed time: $ELAPSED_RUN</td>"
		echo "</tr>"
		echo "<tr>"
		echo "<td $TABLE_FONT>number of errors: $(wc -l errors.log | awk '{printf("%s",$1);}')/$(wc -l nightly.log | awk '{printf("%s",$1);}';  rm errors.log)</td>"
		echo "<td $TABLE_FONT>  </td>"
		echo "</tr>"
		echo "<tr>"
		echo "<td $TABLE_FONT>number of success: $(wc -l success.log | awk '{printf("%s",$1);}')/$(wc -l nightly.log | awk '{printf("%s",$1);}'; rm success.log)</td>"
		echo "<td $TABLE_FONT>  </td>"
		echo "</tr>"
		echo "</table>"

		#draw a line and clean up
		echo "<br><hr width=\"900px\">"
	fi
fi) 
END

#Matlab error report
cat << END > matlaberror.html
<table $H2_STYLE><tr><td $H2_FONT>Matlab error</td></tr></table>
<table $MATLAB_STYLE><tr><td $MATLAB_FONT>
<pre>$(more matlaberror.log)</pre>
</td></tr></table>
END

#report content
if [ $(echo $IS_INSTALL) = 1 ];
then
	cat << END > content.html
<table $(echo $H2_STYLE)><tr><td $(echo $H2_FONT)>List of tests</td></tr></table>
<table $(echo $BODY_STYLE) cellspacing="-1">
<tr> 
<th $(echo $BODY_FONT)>Result</th> 
<th $(echo $BODY_FONT)>Tolerance</th> 
<th $(echo $BODY_FONT)>Test name</th>  
<th $(echo $BODY_FONT)>Analysis type</th> 
<th $(echo $BODY_FONT)>Sub type</th> 
<th $(echo $BODY_FONT)>Qmu</th>
<th $(echo $BODY_FONT)>control</th>
<th $(echo $BODY_FONT)>Control fit</th>
<th $(echo $BODY_FONT)>Parallel</th>
</tr>
$( COUNTER=0
MAX=`wc -l nightly.log | awk '{printf("%s",$1);}'`
while [  $COUNTER -lt $MAX ]; do
	let COUNTER=COUNTER+1 

	echo "<tr>"

	#see wether it is success or error (get color: red or green)
	RESULT="$(cat nightly.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk '/line'$COUNTER'o/ {printf("%s\n",$2);}';)"
	if [ "$RESULT" = "SUCCESS" ];  
	then 
		color="bgcolor=#ddffdd";
	else
		if [ "$RESULT" = "ERROR" ];
		then
			color="bgcolor=#ffdddd";
		else
			color="bgcolor=#ddddff";
		fi
	fi
	FONT=$(echo "$BODY_FONT $color")

	#build html corresponding line
	cat nightly.log | awk '{ printf "line%so %s\n", NR, $0 }' | awk -v FONT="$FONT" '
	/line'$COUNTER'o/ { printf("<td %s>%s</td><td %s>%s%s%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td><td %s>%s</td>",FONT,$2,FONT,$4,$5,$6,FONT,$8,FONT,$10,FONT,$12,FONT,$14,FONT,$16,FONT,$18,FONT,$20);}
	';

	echo "</tr>"

done)
</table>
<br>
END
else
	mktemp content.html
fi

#last footer
cat << END > footer.html
<br>
<table $FOOTER_STYLE><tr><td $FOOTER_FONT><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</td></tr></table>
</div>
END

#concatenate files
if [ $IS_RUN -eq 0 ];
then
	cat summary.html matlaberror.html content.html footer.html > report.html
else
	cat summary.html                  content.html footer.html > report.html
fi
rm  summary.html content.html footer.html matlaberror.html
